/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.representation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.epochx.ant.Ant;
import org.epochx.representation.Action;
import org.epochx.representation.FunctionNode;
import org.epochx.representation.MalformedProgramException;
import org.epochx.representation.Node;
import org.epochx.representation.TerminalNode;
import org.epochx.representation.Variable;
import org.epochx.representation.ant.AntMoveAction;
import org.epochx.representation.ant.AntSkipAction;
import org.epochx.representation.ant.AntTurnLeftAction;
import org.epochx.representation.ant.AntTurnRightAction;
import org.epochx.representation.ant.IfFoodAheadFunction;
import org.epochx.representation.ant.Seq2Function;
import org.epochx.representation.ant.Seq3Function;
import org.epochx.representation.bool.AndFunction;
import org.epochx.representation.bool.IfAndOnlyIfFunction;
import org.epochx.representation.bool.IfFunction;
import org.epochx.representation.bool.ImpliesFunction;
import org.epochx.representation.bool.NandFunction;
import org.epochx.representation.bool.NorFunction;
import org.epochx.representation.bool.NotFunction;
import org.epochx.representation.bool.OrFunction;
import org.epochx.representation.bool.XorFunction;
import org.epochx.representation.dbl.AddFunction;
import org.epochx.representation.dbl.ArcCosineFunction;
import org.epochx.representation.dbl.ArcSineFunction;
import org.epochx.representation.dbl.ArcTangentFunction;
import org.epochx.representation.dbl.CoefficientPowerFunction;
import org.epochx.representation.dbl.CosecantFunction;
import org.epochx.representation.dbl.CosineFunction;
import org.epochx.representation.dbl.CotangentFunction;
import org.epochx.representation.dbl.CubeFunction;
import org.epochx.representation.dbl.FactorialFunction;
import org.epochx.representation.dbl.HyperbolicCosineFunction;
import org.epochx.representation.dbl.HyperbolicSineFunction;
import org.epochx.representation.dbl.HyperbolicTangentFunction;
import org.epochx.representation.dbl.InvertFunction;
import org.epochx.representation.dbl.Log10Function;
import org.epochx.representation.dbl.LogFunction;
import org.epochx.representation.dbl.MaxFunction;
import org.epochx.representation.dbl.MinFunction;
import org.epochx.representation.dbl.ModuloFunction;
import org.epochx.representation.dbl.MultiplyFunction;
import org.epochx.representation.dbl.PowerFunction;
import org.epochx.representation.dbl.ProtectedDivisionFunction;
import org.epochx.representation.dbl.SecantFunction;
import org.epochx.representation.dbl.SignumFunction;
import org.epochx.representation.dbl.SineFunction;
import org.epochx.representation.dbl.SquareFunction;
import org.epochx.representation.dbl.SquareRootFunction;
import org.epochx.representation.dbl.SubtractFunction;
import org.epochx.representation.dbl.TangentFunction;

public class FunctionParser<TYPE> {
    private final Map<String, Class<?>> simpleFunctions = new HashMap();
    private final Map<String, Class<?>> simpleActions = new HashMap();
    private Ant ant;
    private final String Digits = "(\\p{Digit}+)";
    private final String HexDigits = "(\\p{XDigit}+)";
    private final String Exp = "[eE][+-]?(\\p{Digit}+)";
    private final String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";

    public FunctionParser() {
        this.simpleFunctions.put("AND", AndFunction.class);
        this.simpleFunctions.put("IFF", IfAndOnlyIfFunction.class);
        this.simpleFunctions.put("IF", IfFunction.class);
        this.simpleFunctions.put("IMPLIES", ImpliesFunction.class);
        this.simpleFunctions.put("NAND", NandFunction.class);
        this.simpleFunctions.put("NOR", NorFunction.class);
        this.simpleFunctions.put("NOT", NotFunction.class);
        this.simpleFunctions.put("OR", OrFunction.class);
        this.simpleFunctions.put("XOR", XorFunction.class);
        this.simpleFunctions.put("ADD", AddFunction.class);
        this.simpleFunctions.put("ACOS", ArcCosineFunction.class);
        this.simpleFunctions.put("ASIN", ArcSineFunction.class);
        this.simpleFunctions.put("ATAN", ArcTangentFunction.class);
        this.simpleFunctions.put("CVP", CoefficientPowerFunction.class);
        this.simpleFunctions.put("COSEC", CosecantFunction.class);
        this.simpleFunctions.put("COS", CosineFunction.class);
        this.simpleFunctions.put("COT", CotangentFunction.class);
        this.simpleFunctions.put("CUBE", CubeFunction.class);
        this.simpleFunctions.put("FACTORIAL", FactorialFunction.class);
        this.simpleFunctions.put("COSH", HyperbolicCosineFunction.class);
        this.simpleFunctions.put("SINH", HyperbolicSineFunction.class);
        this.simpleFunctions.put("TANH", HyperbolicTangentFunction.class);
        this.simpleFunctions.put("INV", InvertFunction.class);
        this.simpleFunctions.put("LOG-10", Log10Function.class);
        this.simpleFunctions.put("LN", LogFunction.class);
        this.simpleFunctions.put("MAX", MaxFunction.class);
        this.simpleFunctions.put("MIN", MinFunction.class);
        this.simpleFunctions.put("MOD", ModuloFunction.class);
        this.simpleFunctions.put("MUL", MultiplyFunction.class);
        this.simpleFunctions.put("POW", PowerFunction.class);
        this.simpleFunctions.put("PDIV", ProtectedDivisionFunction.class);
        this.simpleFunctions.put("SEC", SecantFunction.class);
        this.simpleFunctions.put("SGN", SignumFunction.class);
        this.simpleFunctions.put("SIN", SineFunction.class);
        this.simpleFunctions.put("SQUARE", SquareFunction.class);
        this.simpleFunctions.put("SQRT", SquareRootFunction.class);
        this.simpleFunctions.put("SUB", SubtractFunction.class);
        this.simpleFunctions.put("TAN", TangentFunction.class);
        this.simpleFunctions.put("SEQ2", Seq2Function.class);
        this.simpleFunctions.put("SEQ3", Seq3Function.class);
    }

    private FunctionNode<?> initialiseFunction(String name) {
        FunctionNode node = null;
        Class<?> functionClass = this.simpleFunctions.get(name);
        if (functionClass != null) {
            try {
                node = (FunctionNode)functionClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        } else if (name.equals("IF-FOOD-AHEAD")) {
            node = new IfFoodAheadFunction(this.ant);
        }
        return node;
    }

    private Action initialiseAction(String name) {
        Action node = null;
        Class<?> actionClass = this.simpleActions.get(name);
        if (actionClass != null) {
            try {
                node = (Action)actionClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        } else if (name.equals("MOVE")) {
            node = new AntMoveAction(this.ant);
        } else if (name.equals("TURN-LEFT")) {
            node = new AntTurnLeftAction(this.ant);
        } else if (name.equals("TURN-RIGHT")) {
            node = new AntTurnRightAction(this.ant);
        } else if (name.equals("SKIP")) {
            node = new AntSkipAction(this.ant);
        }
        return node;
    }

    public Node<TYPE> parse(String source) {
        if (source == null) {
            return null;
        }
        int openingBracket = source.indexOf(40);
        if (openingBracket == -1) {
            return this.parseTerminal(source);
        }
        String functionName = source.substring(0, openingBracket);
        String argumentStr = source.substring(openingBracket + 1, source.length() - 1);
        List<String> args = this.splitArguments(argumentStr);
        Node node = null;
        node = args.size() == 0 ? this.initialiseAction(functionName) : this.initialiseFunction(functionName);
        if (node == null || node.getArity() != args.size()) {
            throw new MalformedProgramException();
        }
        int i = 0;
        while (i < args.size()) {
            node.setChild(i, this.parse(args.get(i)));
            ++i;
        }
        return node;
    }

    private TerminalNode<?> parseTerminal(String terminalStr) {
        if (Pattern.matches("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*", terminalStr)) {
            return new TerminalNode<Double>(Double.valueOf(terminalStr));
        }
        if (terminalStr.equalsIgnoreCase("true") || terminalStr.equalsIgnoreCase("false")) {
            return new TerminalNode<Boolean>(Boolean.valueOf(terminalStr));
        }
        return new Variable(terminalStr);
    }

    public void addSimpleFunction(String name, Class<FunctionNode<?>> functionClass) {
        this.simpleFunctions.put(name, functionClass);
    }

    public void addSimpleAction(String name, Class<Action> actionClass) {
        this.simpleActions.put(name, actionClass);
    }

    public void setAnt(Ant ant) {
        this.ant = ant;
    }

    private List<String> splitArguments(String argStr) {
        int depth = 0;
        ArrayList<String> args = new ArrayList<String>(5);
        StringBuilder buffer = new StringBuilder();
        argStr = argStr.trim();
        int i = 0;
        while (i < argStr.length()) {
            char c = argStr.charAt(i);
            if (c == '(') {
                ++depth;
            } else if (c == ')') {
                --depth;
            }
            if ((c == ' ' || c == ',') && depth == 0) {
                args.add(buffer.toString());
                buffer = new StringBuilder();
            } else {
                buffer.append(c);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            args.add(buffer.toString());
        }
        return args;
    }

    public static void main(String[] args) {
        FunctionParser parser = new FunctionParser();
        Node programTree = parser.parse("XOR(D1 XOR(NOT(XOR(D0 D3)) D2))");
    }
}

