/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.op.mutation;

import org.epochx.core.GPModel;
import org.epochx.op.initialisation.GrowInitialiser;
import org.epochx.op.mutation.Mutation;
import org.epochx.representation.CandidateProgram;
import org.epochx.representation.Node;

public class SubtreeMutation<TYPE>
implements Mutation<TYPE> {
    private GPModel<TYPE> model;
    private int maxSubtreeDepth;

    public SubtreeMutation(GPModel<TYPE> model) {
        this(model, 4);
    }

    public SubtreeMutation(GPModel<TYPE> model, int maxSubtreeDepth) {
        this.model = model;
        this.maxSubtreeDepth = maxSubtreeDepth;
    }

    @Override
    public CandidateProgram<TYPE> mutate(CandidateProgram<TYPE> program) {
        int length = program.getProgramLength();
        int mutationPoint = this.model.getRNG().nextInt(length);
        GrowInitialiser<TYPE> init = new GrowInitialiser<TYPE>(this.model);
        Node<TYPE> subtree = init.buildGrowNodeTree(this.maxSubtreeDepth);
        program.setNthNode(mutationPoint, subtree);
        return program;
    }
}

