/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.op.mutation;

import java.util.List;
import org.epochx.core.GPModel;
import org.epochx.op.mutation.Mutation;
import org.epochx.representation.CandidateProgram;
import org.epochx.representation.FunctionNode;
import org.epochx.representation.Node;
import org.epochx.representation.TerminalNode;

public class PointMutation<TYPE>
implements Mutation<TYPE> {
    private GPModel<TYPE> model;
    private double pointProbability;

    public PointMutation(GPModel<TYPE> model) {
        this(model, 0.01);
    }

    public PointMutation(GPModel<TYPE> model, double pointProbability) {
        this.model = model;
        this.pointProbability = pointProbability;
    }

    @Override
    public CandidateProgram<TYPE> mutate(CandidateProgram<TYPE> program) {
        List<Node<TYPE>> syntax = this.model.getSyntax();
        int length = program.getProgramLength();
        int i = 0;
        while (i < length) {
            if (this.model.getRNG().nextDouble() < this.pointProbability) {
                Node<TYPE> node = program.getNthNode(i);
                int arity = node.getArity();
                int rand = this.model.getRNG().nextInt(syntax.size());
                int j = 0;
                while (j < syntax.size()) {
                    int index = (j + rand) % syntax.size();
                    Node n = syntax.get(index);
                    if (n.getArity() == arity && !this.nodesEqual(node, n)) {
                        n = (Node)n.clone();
                        int k = 0;
                        while (k < arity) {
                            n.setChild(k, node.getChild(k));
                            ++k;
                        }
                        program.setNthNode(i, n);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return program;
    }

    private boolean nodesEqual(Node<TYPE> nodeA, Node<TYPE> nodeB) {
        boolean equal = false;
        if (nodeA.getClass().equals(nodeB.getClass())) {
            if (nodeA instanceof FunctionNode) {
                equal = true;
            } else if (nodeA instanceof TerminalNode) {
                equal = ((TerminalNode)nodeA).equals(nodeB);
            }
        }
        return equal;
    }
}

