/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.op.initialisation;

import java.util.ArrayList;
import java.util.List;
import org.epochx.core.GPModel;
import org.epochx.op.initialisation.Initialiser;
import org.epochx.representation.CandidateProgram;
import org.epochx.representation.Node;

public class FullInitialiser<TYPE>
implements Initialiser<TYPE> {
    private GPModel<TYPE> model;

    public FullInitialiser(GPModel<TYPE> model) {
        this.model = model;
    }

    @Override
    public List<CandidateProgram<TYPE>> getInitialPopulation() {
        int popSize = this.model.getPopulationSize();
        ArrayList<CandidateProgram<TYPE>> firstGen = new ArrayList<CandidateProgram<TYPE>>(popSize);
        int i = 0;
        while (i < popSize) {
            Node<TYPE> nodeTree;
            CandidateProgram<TYPE> candidate;
            while (firstGen.contains(candidate = new CandidateProgram<TYPE>(nodeTree = this.buildFullNodeTree(this.model.getInitialMaxDepth()), this.model))) {
            }
            firstGen.add(candidate);
            ++i;
        }
        return firstGen;
    }

    public Node<TYPE> buildFullNodeTree(int depth) {
        Node root;
        if (depth == 0) {
            int randomIndex = this.model.getRNG().nextInt(this.model.getTerminals().size());
            root = (Node)this.model.getTerminals().get(randomIndex).clone();
        } else {
            int randomIndex = this.model.getRNG().nextInt(this.model.getFunctions().size());
            root = (Node)this.model.getFunctions().get(randomIndex).clone();
            this.fillChildren(root, 0, depth);
        }
        return root;
    }

    private void fillChildren(Node<TYPE> currentNode, int currentDepth, int maxDepth) {
        int arity = currentNode.getArity();
        if (currentDepth < maxDepth - 1) {
            int i = 0;
            while (i < arity) {
                int randomIndex = this.model.getRNG().nextInt(this.model.getFunctions().size());
                Node child = (Node)this.model.getFunctions().get(randomIndex).clone();
                currentNode.setChild(i, child);
                this.fillChildren(child, currentDepth + 1, maxDepth);
                ++i;
            }
        } else {
            int i = 0;
            while (i < arity) {
                int randomIndex = this.model.getRNG().nextInt(this.model.getTerminals().size());
                Node child = (Node)this.model.getTerminals().get(randomIndex).clone();
                currentNode.setChild(i, child);
                ++i;
            }
        }
    }
}

