/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.model.parity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.epochx.core.GPAbstractModel;
import org.epochx.representation.CandidateProgram;
import org.epochx.representation.FunctionNode;
import org.epochx.representation.TerminalNode;
import org.epochx.representation.Variable;
import org.epochx.representation.bool.AndFunction;
import org.epochx.representation.bool.IfFunction;
import org.epochx.representation.bool.NotFunction;
import org.epochx.representation.bool.OrFunction;
import org.epochx.util.BoolUtils;

public class Even5Parity
extends GPAbstractModel<Boolean> {
    private boolean[][] inputs = BoolUtils.generateBoolSequences(5);
    private HashMap<String, Variable<Boolean>> variables = new HashMap();

    public Even5Parity() {
        this.configure();
    }

    public void configure() {
        this.variables.put("D4", new Variable("D4"));
        this.variables.put("D3", new Variable("D3"));
        this.variables.put("D2", new Variable("D2"));
        this.variables.put("D1", new Variable("D1"));
        this.variables.put("D0", new Variable("D0"));
    }

    @Override
    public List<FunctionNode<Boolean>> getFunctions() {
        ArrayList<FunctionNode<Boolean>> functions = new ArrayList<FunctionNode<Boolean>>();
        functions.add(new IfFunction());
        functions.add(new AndFunction());
        functions.add(new OrFunction());
        functions.add(new NotFunction());
        return functions;
    }

    @Override
    public List<TerminalNode<Boolean>> getTerminals() {
        ArrayList<TerminalNode<Boolean>> terminals = new ArrayList<TerminalNode<Boolean>>();
        terminals.add((TerminalNode)this.variables.get("D4"));
        terminals.add((TerminalNode)this.variables.get("D3"));
        terminals.add((TerminalNode)this.variables.get("D2"));
        terminals.add((TerminalNode)this.variables.get("D1"));
        terminals.add((TerminalNode)this.variables.get("D0"));
        return terminals;
    }

    @Override
    public double getFitness(CandidateProgram<Boolean> program) {
        double score = 0.0;
        boolean[][] blArray = this.inputs;
        int n = this.inputs.length;
        int n2 = 0;
        while (n2 < n) {
            boolean[] in = blArray[n2];
            this.variables.get("D0").setValue(in[0]);
            this.variables.get("D1").setValue(in[1]);
            this.variables.get("D2").setValue(in[2]);
            this.variables.get("D3").setValue(in[3]);
            this.variables.get("D4").setValue(in[4]);
            if (program.evaluate().booleanValue() == this.chooseResult(in)) {
                score += 1.0;
            }
            ++n2;
        }
        return 32.0 - score;
    }

    private boolean chooseResult(boolean[] input) {
        int eCount = 0;
        int i = 0;
        while (i < input.length) {
            if (input[i]) {
                ++eCount;
            }
            ++i;
        }
        return eCount % 2 == 0;
    }
}

