/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.life;

import java.util.ArrayList;
import java.util.List;
import org.epochx.life.CrossoverListener;
import org.epochx.life.ElitismListener;
import org.epochx.life.GenerationListener;
import org.epochx.life.InitialisationListener;
import org.epochx.life.MutationListener;
import org.epochx.life.PoolSelectionListener;
import org.epochx.life.ReproductionListener;
import org.epochx.life.RunListener;
import org.epochx.life.TerminationListener;
import org.epochx.representation.CandidateProgram;

public class LifeCycleManager<TYPE> {
    private List<RunListener> runListeners = new ArrayList<RunListener>();
    private List<InitialisationListener<TYPE>> initialisationListeners = new ArrayList<InitialisationListener<TYPE>>();
    private List<ElitismListener<TYPE>> elitismListeners = new ArrayList<ElitismListener<TYPE>>();
    private List<PoolSelectionListener<TYPE>> poolSelectionListeners = new ArrayList<PoolSelectionListener<TYPE>>();
    private List<CrossoverListener<TYPE>> crossoverListeners = new ArrayList<CrossoverListener<TYPE>>();
    private List<MutationListener<TYPE>> mutationListeners = new ArrayList<MutationListener<TYPE>>();
    private List<ReproductionListener<TYPE>> reproductionListeners = new ArrayList<ReproductionListener<TYPE>>();
    private List<GenerationListener> generationListeners = new ArrayList<GenerationListener>();
    private List<TerminationListener> terminationListeners = new ArrayList<TerminationListener>();

    public void addRunListener(RunListener listener) {
        this.runListeners.add(listener);
    }

    public void removeRunListener(RunListener listener) {
        this.runListeners.remove(listener);
    }

    public void addInitialisationListener(InitialisationListener<TYPE> listener) {
        this.initialisationListeners.add(listener);
    }

    public void removeInitialisationListener(InitialisationListener<TYPE> listener) {
        this.initialisationListeners.remove(listener);
    }

    public void addElitismListener(ElitismListener<TYPE> listener) {
        this.elitismListeners.add(listener);
    }

    public void removeElitismListener(ElitismListener<TYPE> listener) {
        this.elitismListeners.remove(listener);
    }

    public void addPoolSelectionListener(PoolSelectionListener<TYPE> listener) {
        this.poolSelectionListeners.add(listener);
    }

    public void removePoolSelectionListener(PoolSelectionListener<TYPE> listener) {
        this.poolSelectionListeners.remove(listener);
    }

    public void addCrossoverListener(CrossoverListener<TYPE> listener) {
        this.crossoverListeners.add(listener);
    }

    public void removeCrossoverListener(CrossoverListener<TYPE> listener) {
        this.crossoverListeners.remove(listener);
    }

    public void addMutationListener(MutationListener<TYPE> listener) {
        this.mutationListeners.add(listener);
    }

    public void removeMutationListener(MutationListener<TYPE> listener) {
        this.mutationListeners.remove(listener);
    }

    public void addReproductionListener(ReproductionListener<TYPE> listener) {
        this.reproductionListeners.add(listener);
    }

    public void removeReproductionListener(ReproductionListener<TYPE> listener) {
        this.reproductionListeners.remove(listener);
    }

    public void addGenerationListener(GenerationListener listener) {
        this.generationListeners.add(listener);
    }

    public void removeGenerationListener(GenerationListener listener) {
        this.generationListeners.remove(listener);
    }

    public void addTerminationListener(TerminationListener listener) {
        this.terminationListeners.add(listener);
    }

    public void removeTerminationListener(TerminationListener listener) {
        this.terminationListeners.remove(listener);
    }

    public void onRunStart() {
        for (RunListener listener : this.runListeners) {
            listener.onRunStart();
        }
    }

    public List<CandidateProgram<TYPE>> onInitialisation(List<CandidateProgram<TYPE>> pop) {
        for (InitialisationListener<TYPE> listener : this.initialisationListeners) {
            pop = listener.onInitialisation(pop);
            if (pop == null) break;
        }
        return pop;
    }

    public List<CandidateProgram<TYPE>> onElitism(List<CandidateProgram<TYPE>> elites) {
        for (ElitismListener<TYPE> listener : this.elitismListeners) {
            elites = listener.onElitism(elites);
        }
        return elites;
    }

    public List<CandidateProgram<TYPE>> onPoolSelection(List<CandidateProgram<TYPE>> pool) {
        for (PoolSelectionListener<TYPE> listener : this.poolSelectionListeners) {
            pool = listener.onPoolSelection(pool);
            if (pool == null) break;
        }
        return pool;
    }

    public CandidateProgram<TYPE>[] onCrossover(CandidateProgram<TYPE>[] parents, CandidateProgram<TYPE>[] children) {
        for (CrossoverListener<TYPE> listener : this.crossoverListeners) {
            children = listener.onCrossover(parents, children);
            if (children == null) break;
        }
        return children;
    }

    public CandidateProgram<TYPE> onMutation(CandidateProgram<TYPE> parent, CandidateProgram<TYPE> child) {
        for (MutationListener<TYPE> listener : this.mutationListeners) {
            child = listener.onMutation(parent, child);
            if (child == null) break;
        }
        return child;
    }

    public CandidateProgram<TYPE> onReproduction(CandidateProgram<TYPE> child) {
        for (ReproductionListener<TYPE> listener : this.reproductionListeners) {
            child = listener.onReproduction(child);
            if (child == null) break;
        }
        return child;
    }

    public void onGenerationStart() {
        for (GenerationListener listener : this.generationListeners) {
            listener.onGenerationStart();
        }
    }

    public void onFitnessTermination() {
        for (TerminationListener listener : this.terminationListeners) {
            listener.onFitnessTermination();
        }
    }

    public void onGenerationTermination() {
        for (TerminationListener listener : this.terminationListeners) {
            listener.onGenerationTermination();
        }
    }
}

