/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import java.util.List;
import org.epochx.core.GPController;
import org.epochx.core.GPModel;
import org.epochx.life.GenerationListener;
import org.epochx.life.LifeCycleManager;
import org.epochx.op.selection.PoolSelector;
import org.epochx.representation.CandidateProgram;

public class GPPoolSelection<TYPE>
implements GenerationListener {
    private GPModel<TYPE> model;
    private LifeCycleManager<TYPE> lifeCycle;
    private PoolSelector<TYPE> poolSelector;
    private int poolSize;
    private int reversions;

    public GPPoolSelection(GPModel<TYPE> model) {
        this.model = model;
        this.lifeCycle = GPController.getLifeCycleManager();
        this.lifeCycle.addGenerationListener(this);
        this.initialise();
    }

    private void initialise() {
        this.poolSize = this.model.getPoolSize();
        this.poolSelector = this.model.getPoolSelector();
    }

    public List<CandidateProgram<TYPE>> getPool(List<CandidateProgram<TYPE>> pop) {
        List<CandidateProgram<TYPE>> pool = null;
        this.reversions = -1;
        do {
            pool = this.poolSelector.getPool(pop, this.poolSize);
            pool = this.lifeCycle.onPoolSelection(pool);
            ++this.reversions;
        } while (pool == null);
        return pool;
    }

    public int getReversions() {
        return this.reversions;
    }

    @Override
    public void onGenerationStart() {
        this.initialise();
    }
}

