/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import org.epochx.core.GPController;
import org.epochx.core.GPModel;
import org.epochx.life.GenerationListener;
import org.epochx.life.LifeCycleManager;
import org.epochx.op.mutation.Mutation;
import org.epochx.op.selection.ProgramSelector;
import org.epochx.representation.CandidateProgram;
import org.epochx.stats.MutationStats;

public class GPMutation<TYPE>
implements GenerationListener {
    private GPModel<TYPE> model;
    private LifeCycleManager<TYPE> lifeCycle;
    private ProgramSelector<TYPE> programSelector;
    private Mutation<TYPE> mutator;
    private MutationStats<TYPE> mutationStats;
    private int maxProgramDepth;
    private int reversions;

    public GPMutation(GPModel<TYPE> model) {
        this.model = model;
        this.lifeCycle = GPController.getLifeCycleManager();
        this.lifeCycle.addGenerationListener(this);
        this.mutationStats = new MutationStats();
        this.mutationStats.addMutationStatListener(model.getMutationStatListener());
        this.initialise();
    }

    private void initialise() {
        this.maxProgramDepth = this.model.getMaxProgramDepth();
        this.programSelector = this.model.getProgramSelector();
        this.mutator = this.model.getMutator();
    }

    public CandidateProgram<TYPE> mutate() {
        long crossoverStartTime = System.nanoTime();
        CandidateProgram<TYPE> parent = null;
        CandidateProgram child = null;
        this.reversions = -1;
        do {
            parent = this.programSelector.getProgram();
            child = (CandidateProgram)parent.clone();
            child = this.mutator.mutate(child);
            child = this.lifeCycle.onMutation(parent, child);
            ++this.reversions;
        } while (child == null);
        if (child.getProgramDepth() > this.maxProgramDepth) {
            child = (CandidateProgram)parent.clone();
        }
        long runtime = System.nanoTime() - crossoverStartTime;
        this.mutationStats.addMutation(parent, child, runtime, this.reversions);
        return child;
    }

    public int getRevertedCount() {
        return this.reversions;
    }

    @Override
    public void onGenerationStart() {
        this.initialise();
    }
}

