/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import java.util.List;
import org.epochx.life.LifeCycleListener;
import org.epochx.op.crossover.Crossover;
import org.epochx.op.initialisation.Initialiser;
import org.epochx.op.mutation.Mutation;
import org.epochx.op.selection.PoolSelector;
import org.epochx.op.selection.ProgramSelector;
import org.epochx.random.RandomNumberGenerator;
import org.epochx.representation.CandidateProgram;
import org.epochx.representation.FunctionNode;
import org.epochx.representation.Node;
import org.epochx.representation.TerminalNode;
import org.epochx.stats.CrossoverStatListener;
import org.epochx.stats.GenerationStatListener;
import org.epochx.stats.MutationStatListener;
import org.epochx.stats.RunStatListener;

public interface GPModel<TYPE> {
    public Initialiser<TYPE> getInitialiser();

    public Crossover<TYPE> getCrossover();

    public Mutation<TYPE> getMutator();

    public ProgramSelector<TYPE> getProgramSelector();

    public PoolSelector<TYPE> getPoolSelector();

    public List<TerminalNode<TYPE>> getTerminals();

    public List<FunctionNode<TYPE>> getFunctions();

    public List<Node<TYPE>> getSyntax();

    public RandomNumberGenerator getRNG();

    public int getNoRuns();

    public int getNoGenerations();

    public int getPopulationSize();

    public int getPoolSize();

    public int getNoElites();

    public int getInitialMaxDepth();

    public int getMaxProgramDepth();

    public double getCrossoverProbability();

    public double getMutationProbability();

    public double getReproductionProbability();

    public double getFitness(CandidateProgram<TYPE> var1);

    public double getTerminationFitness();

    public boolean acceptCrossover(CandidateProgram<TYPE>[] var1, CandidateProgram<TYPE>[] var2);

    public boolean acceptMutation(CandidateProgram<TYPE> var1, CandidateProgram<TYPE> var2);

    public RunStatListener getRunStatListener();

    public GenerationStatListener getGenerationStatListener();

    public CrossoverStatListener getCrossoverStatListener();

    public MutationStatListener getMutationStatListener();

    public LifeCycleListener<TYPE> getLifeCycleListener();
}

