/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import java.util.ArrayList;
import java.util.List;
import org.epochx.core.GPController;
import org.epochx.core.GPCrossover;
import org.epochx.core.GPElitism;
import org.epochx.core.GPModel;
import org.epochx.core.GPMutation;
import org.epochx.core.GPPoolSelection;
import org.epochx.core.GPReproduction;
import org.epochx.life.LifeCycleManager;
import org.epochx.random.RandomNumberGenerator;
import org.epochx.representation.CandidateProgram;

public class GPGeneration<TYPE> {
    private GPModel<TYPE> model;
    private LifeCycleManager<TYPE> lifeCycle;
    private GPElitism<TYPE> elitism;
    private GPPoolSelection<TYPE> poolSelection;
    private GPCrossover<TYPE> crossover;
    private GPMutation<TYPE> mutation;
    private GPReproduction<TYPE> reproduction;
    private RandomNumberGenerator rng;
    private double mutationProbability;
    private double crossoverProbability;

    public GPGeneration(GPModel<TYPE> model) {
        this.model = model;
        this.lifeCycle = GPController.getLifeCycleManager();
        this.elitism = new GPElitism<TYPE>(model);
        this.poolSelection = new GPPoolSelection<TYPE>(model);
        this.crossover = new GPCrossover<TYPE>(model);
        this.mutation = new GPMutation<TYPE>(model);
        this.reproduction = new GPReproduction<TYPE>(model);
    }

    private void reset() {
        this.rng = this.model.getRNG();
        this.mutationProbability = this.model.getMutationProbability();
        this.crossoverProbability = this.model.getCrossoverProbability();
    }

    public List<CandidateProgram<TYPE>> generation(List<CandidateProgram<TYPE>> previousPop) {
        this.reset();
        this.lifeCycle.onGenerationStart();
        int popSize = this.model.getPopulationSize();
        ArrayList<CandidateProgram<TYPE>> pop = new ArrayList<CandidateProgram<TYPE>>(popSize);
        pop.addAll(this.elitism.getElites(previousPop));
        List<CandidateProgram<TYPE>> pool = this.poolSelection.getPool(previousPop);
        this.model.getProgramSelector().setSelectionPool(pool);
        while (pop.size() < popSize) {
            double random = this.rng.nextDouble();
            if (random < this.crossoverProbability) {
                CandidateProgram<TYPE>[] children;
                CandidateProgram<TYPE>[] candidateProgramArray = children = this.crossover.crossover();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    CandidateProgram<TYPE> c = candidateProgramArray[n2];
                    if (pop.size() < popSize) {
                        pop.add(c);
                    }
                    ++n2;
                }
                continue;
            }
            if (random < this.crossoverProbability + this.mutationProbability) {
                pop.add(this.mutation.mutate());
                continue;
            }
            pop.add(this.reproduction.reproduce());
        }
        return pop;
    }
}

