/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.ant;

import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import org.epochx.ant.Orientation;

public class AntLandscape {
    private Dimension size;
    private List<Point> foodLocations;

    public AntLandscape(Dimension size, List<Point> foodLocations) {
        this.size = size;
        this.foodLocations = foodLocations;
    }

    public void addFoodLocation(Point location) {
        this.foodLocations.add(location);
    }

    public void removeFoodLocation(Point location) {
        this.foodLocations.remove(location);
    }

    public boolean isFoodLocation(Point location) {
        return this.foodLocations.contains(location);
    }

    public void setFoodLocations(List<Point> foodLocations) {
        this.foodLocations = foodLocations;
    }

    public void clearFoodLocations() {
        this.foodLocations.clear();
    }

    public Dimension getSize() {
        return this.size;
    }

    public int getWidth() {
        return this.size.width;
    }

    public int getHeight() {
        return this.size.height;
    }

    public boolean isValidLocation(Point location) {
        return location.x >= 0 && location.x < this.size.width && location.y >= 0 && location.y < this.size.height;
    }

    public Point getNextLocation(Point location, Orientation orientation) {
        Point newLocation = new Point(location);
        switch (orientation) {
            case NORTH: {
                newLocation.y = location.y > 0 ? location.y - 1 : this.size.height - 1;
                break;
            }
            case EAST: {
                newLocation.x = location.x < this.size.width - 1 ? location.x + 1 : 0;
                break;
            }
            case SOUTH: {
                newLocation.y = location.y < this.size.height - 1 ? location.y + 1 : 0;
                break;
            }
            case WEST: {
                newLocation.x = location.x > 0 ? location.y - 1 : this.size.width - 1;
                break;
            }
        }
        return newLocation;
    }
}

