/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.epochx.core.GPRun;
import org.epochx.stats.RunStatField;
import org.epochx.stats.RunStatListener;

public class RunStats<TYPE> {
    public List<RunStatListener> listeners = new ArrayList<RunStatListener>();

    public void addRunStatListener(RunStatListener listener) {
        this.listeners.add(listener);
    }

    public void removeRunStatListener(RunStatListener listener) {
        this.listeners.remove(listener);
    }

    public void addRun(GPRun<TYPE> run, int runNo) {
        HashMap<RunStatField, Object> stats = new HashMap<RunStatField, Object>();
        HashMap<RunStatListener, RunStatField[]> requestedStats = new HashMap<RunStatListener, RunStatField[]>();
        for (RunStatListener l : this.listeners) {
            RunStatField[] fields = l.getRunStatFields();
            if (fields == null) {
                fields = new RunStatField[]{};
            }
            requestedStats.put(l, fields);
            RunStatField[] runStatFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                RunStatField sf = runStatFieldArray[n2];
                if (!stats.containsKey((Object)sf)) {
                    stats.put(sf, "");
                }
                ++n2;
            }
        }
        this.gatherStats(stats, run);
        Set ls = requestedStats.keySet();
        for (RunStatListener l : ls) {
            RunStatField[] statFields = (RunStatField[])requestedStats.get(l);
            Object[] statResults = new Object[statFields.length];
            int i = 0;
            while (i < statFields.length) {
                statResults[i] = stats.get((Object)statFields[i]);
                ++i;
            }
            l.runStats(runNo, statResults);
        }
    }

    private void gatherStats(Map<RunStatField, Object> stats, GPRun<TYPE> run) {
        if (stats.containsKey((Object)RunStatField.BEST_PROGRAM)) {
            stats.put(RunStatField.BEST_PROGRAM, run.getBestProgram());
        }
        if (stats.containsKey((Object)RunStatField.BEST_FITNESS)) {
            stats.put(RunStatField.BEST_FITNESS, run.getBestFitness());
        }
        if (stats.containsKey((Object)RunStatField.RUN_TIME)) {
            stats.put(RunStatField.RUN_TIME, run.getRunTime());
        }
    }
}

