/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.epochx.representation.CandidateProgram;
import org.epochx.stats.MutationStatField;
import org.epochx.stats.MutationStatListener;

public class MutationStats<TYPE> {
    public List<MutationStatListener> listeners = new ArrayList<MutationStatListener>();

    public void addMutationStatListener(MutationStatListener listener) {
        this.listeners.add(listener);
    }

    public void removeMutationStatListener(MutationStatListener listener) {
        this.listeners.remove(listener);
    }

    public void addMutation(CandidateProgram<TYPE> parent, CandidateProgram<TYPE> child, long runtime, int reversions) {
        HashMap<MutationStatField, Object> stats = new HashMap<MutationStatField, Object>();
        HashMap<MutationStatListener, MutationStatField[]> requestedStats = new HashMap<MutationStatListener, MutationStatField[]>();
        for (MutationStatListener l : this.listeners) {
            MutationStatField[] fields = l.getMutationStatFields();
            if (fields == null) {
                fields = new MutationStatField[]{};
            }
            requestedStats.put(l, fields);
            MutationStatField[] mutationStatFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                MutationStatField sf = mutationStatFieldArray[n2];
                if (!stats.containsKey((Object)sf)) {
                    stats.put(sf, "");
                }
                ++n2;
            }
        }
        this.gatherStats(stats, parent, child, runtime, reversions);
        Set ls = requestedStats.keySet();
        for (MutationStatListener l : ls) {
            MutationStatField[] statFields = (MutationStatField[])requestedStats.get(l);
            Object[] statResults = new Object[statFields.length];
            int i = 0;
            while (i < statFields.length) {
                statResults[i] = stats.get((Object)statFields[i]);
                ++i;
            }
            l.mutationStats(statResults);
        }
    }

    private void gatherStats(Map<MutationStatField, Object> stats, CandidateProgram<TYPE> parent, CandidateProgram<TYPE> child, long runtime, int reversions) {
        if (stats.containsKey((Object)MutationStatField.PROGRAM_BEFORE)) {
            stats.put(MutationStatField.PROGRAM_BEFORE, parent);
        }
        if (stats.containsKey((Object)MutationStatField.PROGRAM_AFTER)) {
            stats.put(MutationStatField.PROGRAM_AFTER, child);
        }
        if (stats.containsKey((Object)MutationStatField.RUN_TIME)) {
            stats.put(MutationStatField.RUN_TIME, runtime);
        }
        if (stats.containsKey((Object)MutationStatField.REVERTED_MUTATIONS)) {
            stats.put(MutationStatField.REVERTED_MUTATIONS, reversions);
        }
    }
}

