/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.epochx.representation.CandidateProgram;
import org.epochx.stats.CrossoverStatField;
import org.epochx.stats.CrossoverStatListener;

public class CrossoverStats<TYPE> {
    public List<CrossoverStatListener> listeners = new ArrayList<CrossoverStatListener>();

    public void addCrossoverStatListener(CrossoverStatListener listener) {
        this.listeners.add(listener);
    }

    public void removeCrossoverStatListener(CrossoverStatListener listener) {
        this.listeners.remove(listener);
    }

    public void addCrossover(CandidateProgram<TYPE>[] parents, CandidateProgram<TYPE>[] children, long runtime, int reversions) {
        HashMap<CrossoverStatField, Object> stats = new HashMap<CrossoverStatField, Object>();
        HashMap<CrossoverStatListener, CrossoverStatField[]> requestedStats = new HashMap<CrossoverStatListener, CrossoverStatField[]>();
        for (CrossoverStatListener l : this.listeners) {
            CrossoverStatField[] fields = l.getCrossoverStatFields();
            if (fields == null) {
                fields = new CrossoverStatField[]{};
            }
            requestedStats.put(l, fields);
            CrossoverStatField[] crossoverStatFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                CrossoverStatField sf = crossoverStatFieldArray[n2];
                if (!stats.containsKey((Object)sf)) {
                    stats.put(sf, "");
                }
                ++n2;
            }
        }
        this.gatherStats(stats, parents, children, runtime, reversions);
        Set ls = requestedStats.keySet();
        for (CrossoverStatListener l : ls) {
            CrossoverStatField[] statFields = (CrossoverStatField[])requestedStats.get(l);
            Object[] statResults = new Object[statFields.length];
            int i = 0;
            while (i < statFields.length) {
                statResults[i] = stats.get((Object)statFields[i]);
                ++i;
            }
            l.crossoverStats(statResults);
        }
    }

    private void gatherStats(Map<CrossoverStatField, Object> stats, CandidateProgram<TYPE>[] parents, CandidateProgram<TYPE>[] children, long runtime, int reversions) {
        if (stats.containsKey((Object)CrossoverStatField.PARENTS)) {
            stats.put(CrossoverStatField.PARENTS, parents);
        }
        if (stats.containsKey((Object)CrossoverStatField.CHILDREN)) {
            stats.put(CrossoverStatField.CHILDREN, children);
        }
        if (stats.containsKey((Object)CrossoverStatField.RUN_TIME)) {
            stats.put(CrossoverStatField.RUN_TIME, runtime);
        }
        if (stats.containsKey((Object)CrossoverStatField.REVERTED_CROSSOVERS)) {
            stats.put(CrossoverStatField.REVERTED_CROSSOVERS, reversions);
        }
    }
}

