/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.representation.dbl;

import org.epochx.representation.FunctionNode;
import org.epochx.representation.Node;

public class ProtectedDivisionFunction
extends FunctionNode<Double> {
    private Double protectionValue;

    public ProtectedDivisionFunction() {
        this((Node<Double>)null, (Node<Double>)null);
    }

    public ProtectedDivisionFunction(Double protectionValue) {
        this(null, null, protectionValue);
    }

    public ProtectedDivisionFunction(Node<Double> dividend, Node<Double> divisor) {
        this(dividend, divisor, 0.0);
    }

    public ProtectedDivisionFunction(Node<Double> dividend, Node<Double> divisor, Double protectionValue) {
        super(dividend, divisor);
        this.protectionValue = protectionValue;
    }

    @Override
    public Double evaluate() {
        double c1 = (Double)this.getChild(0).evaluate();
        double c2 = (Double)this.getChild(1).evaluate();
        if (c2 == 0.0) {
            return this.protectionValue;
        }
        return c1 / c2;
    }

    @Override
    public String getFunctionName() {
        return "PDIV";
    }
}

