/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.op.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.epochx.core.GPModel;
import org.epochx.op.selection.PoolSelector;
import org.epochx.op.selection.ProgramSelector;
import org.epochx.representation.CandidateProgram;

public class LinearRankSelector<TYPE>
implements ProgramSelector<TYPE>,
PoolSelector<TYPE> {
    private GPModel<TYPE> model;
    private List<CandidateProgram<TYPE>> pop;
    private double[] probabilities;
    private double nPlus;
    private double nMinus;
    private double gradient;

    public LinearRankSelector(GPModel<TYPE> model, double gradient) {
        this.model = model;
        this.gradient = gradient;
        this.nMinus = 2.0 / (gradient + 1.0);
        this.nPlus = 2.0 * gradient / (gradient + 1.0);
    }

    @Override
    public void setSelectionPool(List<CandidateProgram<TYPE>> pop) {
        Collections.sort(pop);
        this.pop = pop;
        int popSize = pop.size();
        this.probabilities = new double[popSize];
        double total = 0.0;
        int i = 1;
        while (i <= popSize) {
            double N = popSize;
            double p = 1.0 / N * (this.nMinus + (this.nPlus - this.nMinus) * ((double)(i - 1) / (N - 1.0)));
            this.probabilities[i - 1] = total += p;
            ++i;
        }
    }

    @Override
    public CandidateProgram<TYPE> getProgram() {
        double ran = this.model.getRNG().nextDouble();
        int i = 0;
        while (i < this.probabilities.length) {
            if (ran < this.probabilities[i]) {
                return this.pop.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public List<CandidateProgram<TYPE>> getPool(List<CandidateProgram<TYPE>> pop, int poolSize) {
        if (poolSize <= 0) {
            return pop;
        }
        LinearRankSelector<TYPE> programSelector = new LinearRankSelector<TYPE>(this.model, this.gradient);
        programSelector.setSelectionPool(pop);
        ArrayList<CandidateProgram<TYPE>> pool = new ArrayList<CandidateProgram<TYPE>>();
        int i = 0;
        while (i < poolSize) {
            pool.add(programSelector.getProgram());
            ++i;
        }
        return pool;
    }
}

