/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.op.initialisation;

import java.util.ArrayList;
import java.util.List;
import org.epochx.core.GPModel;
import org.epochx.op.initialisation.Initialiser;
import org.epochx.representation.CandidateProgram;
import org.epochx.representation.Node;

public class GrowInitialiser<TYPE>
implements Initialiser<TYPE> {
    private GPModel<TYPE> model;

    public GrowInitialiser(GPModel<TYPE> model) {
        this.model = model;
    }

    @Override
    public List<CandidateProgram<TYPE>> getInitialPopulation() {
        int popSize = this.model.getPopulationSize();
        ArrayList<CandidateProgram<TYPE>> firstGen = new ArrayList<CandidateProgram<TYPE>>(popSize);
        int i = 0;
        while (i < popSize) {
            Node<TYPE> nodeTree;
            CandidateProgram<TYPE> candidate;
            while (firstGen.contains(candidate = new CandidateProgram<TYPE>(nodeTree = this.buildGrowNodeTree(this.model.getInitialMaxDepth()), this.model))) {
            }
            firstGen.add(candidate);
            ++i;
        }
        return firstGen;
    }

    public Node<TYPE> buildGrowNodeTree(int maxDepth) {
        int randomIndex = this.model.getRNG().nextInt(this.model.getSyntax().size());
        Node root = (Node)this.model.getSyntax().get(randomIndex).clone();
        this.fillChildren(root, 0, maxDepth);
        return root;
    }

    private void fillChildren(Node<TYPE> currentNode, int currentDepth, int maxDepth) {
        block4: {
            int arity = currentNode.getArity();
            if (arity <= 0) break block4;
            if (currentDepth < maxDepth - 1) {
                int i = 0;
                while (i < arity) {
                    int randomIndex = this.model.getRNG().nextInt(this.model.getSyntax().size());
                    Node child = (Node)this.model.getSyntax().get(randomIndex).clone();
                    currentNode.setChild(i, child);
                    this.fillChildren(child, currentDepth + 1, maxDepth);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < arity) {
                    int randomIndex = this.model.getRNG().nextInt(this.model.getTerminals().size());
                    Node child = (Node)this.model.getTerminals().get(randomIndex).clone();
                    currentNode.setChild(i, child);
                    ++i;
                }
            }
        }
    }
}

