/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.model.regression;

import java.util.ArrayList;
import java.util.List;
import org.epochx.core.GPAbstractModel;
import org.epochx.representation.CandidateProgram;
import org.epochx.representation.FunctionNode;
import org.epochx.representation.TerminalNode;
import org.epochx.representation.Variable;
import org.epochx.representation.dbl.AddFunction;
import org.epochx.representation.dbl.MultiplyFunction;
import org.epochx.representation.dbl.ProtectedDivisionFunction;
import org.epochx.representation.dbl.SubtractFunction;

public class QuarticRegression
extends GPAbstractModel<Double> {
    private Variable<Double> x;

    public QuarticRegression() {
        this.configure();
    }

    public void configure() {
        this.x = new Variable("X");
    }

    @Override
    public List<FunctionNode<Double>> getFunctions() {
        ArrayList<FunctionNode<Double>> functions = new ArrayList<FunctionNode<Double>>();
        functions.add(new AddFunction());
        functions.add(new SubtractFunction());
        functions.add(new MultiplyFunction());
        functions.add(new ProtectedDivisionFunction());
        return functions;
    }

    @Override
    public List<TerminalNode<Double>> getTerminals() {
        ArrayList<TerminalNode<Double>> terminals = new ArrayList<TerminalNode<Double>>();
        terminals.add(new TerminalNode<Double>(5.0));
        terminals.add(new TerminalNode<Double>(4.0));
        terminals.add(new TerminalNode<Double>(3.0));
        terminals.add(new TerminalNode<Double>(2.0));
        terminals.add(new TerminalNode<Double>(1.0));
        terminals.add(new TerminalNode<Double>(0.0));
        terminals.add(new TerminalNode<Double>(-5.0));
        terminals.add(new TerminalNode<Double>(-4.0));
        terminals.add(new TerminalNode<Double>(-3.0));
        terminals.add(new TerminalNode<Double>(-2.0));
        terminals.add(new TerminalNode<Double>(-1.0));
        terminals.add(this.x);
        return terminals;
    }

    @Override
    public double getFitness(CandidateProgram<Double> program) {
        double[] inputs = new double[]{-1.0, -0.9, -0.8, -0.7, -0.6, -0.5, -0.4, -0.3, -0.2, -0.1, 0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};
        int noWrong = 0;
        double[] dArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            double in = dArray[n2];
            this.x.setValue(in);
            if (program.evaluate().doubleValue() != this.getCorrectResult(in)) {
                ++noWrong;
            }
            ++n2;
        }
        return noWrong;
    }

    private double getCorrectResult(double x) {
        return x + x * x + x * x * x + x * x * x * x;
    }
}

