/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.model.ant;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.epochx.ant.Ant;
import org.epochx.ant.AntLandscape;
import org.epochx.core.GPAbstractModel;
import org.epochx.core.GPController;
import org.epochx.representation.CandidateProgram;
import org.epochx.representation.FunctionNode;
import org.epochx.representation.TerminalNode;
import org.epochx.representation.ant.AntMoveAction;
import org.epochx.representation.ant.AntTurnLeftAction;
import org.epochx.representation.ant.AntTurnRightAction;
import org.epochx.representation.ant.IfFoodAheadFunction;
import org.epochx.representation.ant.Seq2Function;
import org.epochx.representation.ant.Seq3Function;
import org.epochx.stats.GenerationStatField;

public class JohnMuirTrail
extends GPAbstractModel<Object> {
    private AntLandscape landscape = new AntLandscape(new Dimension(32, 32), null);
    private Ant ant = new Ant(600, this.landscape);
    private static final Point[] foodLocations = new Point[]{new Point(1, 0), new Point(2, 0), new Point(3, 0), new Point(4, 0), new Point(5, 0), new Point(6, 0), new Point(7, 0), new Point(8, 0), new Point(9, 0), new Point(10, 0), new Point(10, 1), new Point(10, 2), new Point(10, 3), new Point(10, 4), new Point(10, 5), new Point(10, 6), new Point(10, 7), new Point(10, 8), new Point(10, 9), new Point(10, 10), new Point(9, 10), new Point(8, 10), new Point(7, 10), new Point(6, 10), new Point(5, 10), new Point(4, 10), new Point(3, 10), new Point(3, 9), new Point(3, 8), new Point(3, 7), new Point(3, 6), new Point(3, 5), new Point(2, 5), new Point(1, 5), new Point(0, 5), new Point(31, 5), new Point(30, 5), new Point(29, 5), new Point(28, 5), new Point(27, 5), new Point(26, 5), new Point(25, 5), new Point(24, 6), new Point(24, 7), new Point(24, 8), new Point(24, 9), new Point(24, 10), new Point(23, 11), new Point(22, 11), new Point(21, 11), new Point(20, 11), new Point(19, 11), new Point(18, 12), new Point(18, 13), new Point(18, 14), new Point(18, 15), new Point(18, 16), new Point(18, 17), new Point(18, 20), new Point(18, 21), new Point(18, 22), new Point(18, 23), new Point(18, 24), new Point(18, 25), new Point(17, 27), new Point(16, 27), new Point(15, 27), new Point(14, 27), new Point(13, 27), new Point(12, 27), new Point(10, 27), new Point(9, 27), new Point(8, 27), new Point(7, 27), new Point(4, 27), new Point(4, 26), new Point(4, 25), new Point(4, 24), new Point(5, 22), new Point(7, 21), new Point(8, 18), new Point(11, 17), new Point(12, 15), new Point(15, 14), new Point(14, 12), new Point(11, 11), new Point(12, 8), new Point(14, 7), new Point(15, 4)};

    @Override
    public List<FunctionNode<Object>> getFunctions() {
        ArrayList<FunctionNode<Object>> functions = new ArrayList<FunctionNode<Object>>();
        functions.add(new IfFoodAheadFunction(this.ant));
        functions.add(new Seq2Function());
        functions.add(new Seq3Function());
        return functions;
    }

    @Override
    public List<TerminalNode<Object>> getTerminals() {
        ArrayList<TerminalNode<Object>> terminals = new ArrayList<TerminalNode<Object>>();
        terminals.add(new AntMoveAction(this.ant));
        terminals.add(new AntTurnLeftAction(this.ant));
        terminals.add(new AntTurnRightAction(this.ant));
        return terminals;
    }

    @Override
    public double getFitness(CandidateProgram<Object> program) {
        this.landscape.setFoodLocations(new ArrayList<Point>(Arrays.asList(foodLocations)));
        this.ant.reset(600, this.landscape);
        while (this.ant.getMoves() < this.ant.getMaxMoves()) {
            program.evaluate();
        }
        double score = foodLocations.length - this.ant.getFoodEaten();
        return score;
    }

    public Ant getAnt() {
        return this.ant;
    }

    public AntLandscape getAntLandScape() {
        return this.landscape;
    }

    public static void main(String[] args) {
        JohnMuirTrail model = new JohnMuirTrail();
        model.setGenStatFields(new GenerationStatField[]{GenerationStatField.FITNESS_MIN});
        GPController.run(model);
    }
}

