/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import org.epochx.core.GPController;
import org.epochx.core.GPModel;
import org.epochx.life.GenerationListener;
import org.epochx.life.LifeCycleManager;
import org.epochx.op.selection.ProgramSelector;
import org.epochx.representation.CandidateProgram;

public class GPReproduction<TYPE>
implements GenerationListener {
    private LifeCycleManager<TYPE> lifeCycle;
    private GPModel<TYPE> model;
    private ProgramSelector<TYPE> programSelector;
    private int reversions;

    public GPReproduction(GPModel<TYPE> model) {
        this.model = model;
        this.lifeCycle = GPController.getLifeCycleManager();
        this.lifeCycle.addGenerationListener(this);
        this.initialise();
    }

    private void initialise() {
        this.programSelector = this.model.getProgramSelector();
    }

    public CandidateProgram<TYPE> reproduce() {
        CandidateProgram<TYPE> parent = null;
        this.reversions = -1;
        do {
            parent = this.programSelector.getProgram();
            parent = this.lifeCycle.onReproduction(parent);
            ++this.reversions;
        } while (parent == null);
        return parent;
    }

    public int getReversions() {
        return this.reversions;
    }

    @Override
    public void onGenerationStart() {
        this.initialise();
    }
}

