/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.epochx.core.GPController;
import org.epochx.core.GPModel;
import org.epochx.life.GenerationListener;
import org.epochx.life.LifeCycleManager;
import org.epochx.representation.CandidateProgram;

public class GPElitism<TYPE>
implements GenerationListener {
    private GPModel<TYPE> model;
    private LifeCycleManager<TYPE> lifeCycle;
    private int noElites;

    public GPElitism(GPModel<TYPE> model) {
        this.model = model;
        this.lifeCycle = GPController.getLifeCycleManager();
        this.lifeCycle.addGenerationListener(this);
        this.initialise();
    }

    private void initialise() {
        this.noElites = this.model.getNoElites();
        int popSize = this.model.getPopulationSize();
        this.noElites = this.noElites < popSize ? this.noElites : popSize;
    }

    public List<CandidateProgram<TYPE>> getElites(List<CandidateProgram<TYPE>> pop) {
        List elites;
        if (this.noElites > 0) {
            Collections.sort(pop);
            elites = new ArrayList<CandidateProgram<TYPE>>(pop.subList(pop.size() - this.noElites, pop.size()));
        } else {
            elites = new ArrayList();
        }
        elites = this.lifeCycle.onElitism(elites);
        return elites;
    }

    @Override
    public void onGenerationStart() {
        this.initialise();
    }
}

