/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.core;

import org.epochx.core.GPModel;
import org.epochx.core.GPRun;
import org.epochx.life.LifeCycleManager;
import org.epochx.stats.RunStats;

public class GPController<TYPE> {
    private static GPController<?> controller;
    private LifeCycleManager<TYPE> lifeCycle = new LifeCycleManager();

    private GPController() {
    }

    public static <TYPE> GPRun<TYPE>[] run(GPModel<TYPE> model) {
        if (controller == null) {
            controller = new GPController<TYPE>();
        }
        GPRun[] runs = new GPRun[model.getNoRuns()];
        RunStats runStats = new RunStats();
        runStats.addRunStatListener(model.getRunStatListener());
        int i = 0;
        while (i < model.getNoRuns()) {
            runs[i] = GPRun.run(model);
            runStats.addRun(runs[i], i + 1);
            ++i;
        }
        return runs;
    }

    public static <TYPE> LifeCycleManager<TYPE> getLifeCycleManager() {
        if (controller == null) {
            controller = new GPController<TYPE>();
        }
        return GPController.controller.lifeCycle;
    }
}

