/*
 * Decompiled with CFR 0.152.
 */
package org.epochx.ant;

import java.awt.Point;
import org.epochx.ant.AntLandscape;
import org.epochx.ant.Orientation;

public class Ant {
    private Orientation orientation;
    private int timesteps;
    private int maxTimesteps;
    private int xLocation;
    private int yLocation;
    private int foodEaten;
    private AntLandscape landscape;

    public Ant(int timeSteps, AntLandscape landscape) {
        this.reset(timeSteps, landscape);
    }

    public void reset(int timeSteps, AntLandscape landscape) {
        this.maxTimesteps = timeSteps;
        this.landscape = landscape;
        this.reset();
    }

    public void reset() {
        this.orientation = Orientation.EAST;
        this.timesteps = 0;
        this.xLocation = 0;
        this.yLocation = 0;
        this.foodEaten = 0;
    }

    public void turnLeft() {
        if (this.timesteps >= this.maxTimesteps) {
            return;
        }
        if (this.orientation == Orientation.EAST) {
            this.orientation = Orientation.NORTH;
        } else if (this.orientation == Orientation.NORTH) {
            this.orientation = Orientation.WEST;
        } else if (this.orientation == Orientation.WEST) {
            this.orientation = Orientation.SOUTH;
        } else if (this.orientation == Orientation.SOUTH) {
            this.orientation = Orientation.EAST;
        }
        ++this.timesteps;
    }

    public void turnRight() {
        if (this.timesteps >= this.maxTimesteps) {
            return;
        }
        if (this.orientation == Orientation.EAST) {
            this.orientation = Orientation.SOUTH;
        } else if (this.orientation == Orientation.SOUTH) {
            this.orientation = Orientation.WEST;
        } else if (this.orientation == Orientation.WEST) {
            this.orientation = Orientation.NORTH;
        } else if (this.orientation == Orientation.NORTH) {
            this.orientation = Orientation.EAST;
        }
        ++this.timesteps;
    }

    public void move() {
        if (this.timesteps >= this.maxTimesteps) {
            return;
        }
        if (this.orientation == Orientation.EAST) {
            this.xLocation = this.xLocation < 31 ? ++this.xLocation : 0;
        } else if (this.orientation == Orientation.NORTH) {
            this.yLocation = this.yLocation > 0 ? --this.yLocation : 31;
        } else if (this.orientation == Orientation.WEST) {
            this.xLocation = this.xLocation > 0 ? --this.xLocation : 31;
        } else if (this.orientation == Orientation.SOUTH) {
            this.yLocation = this.yLocation < 31 ? ++this.yLocation : 0;
        }
        ++this.timesteps;
        if (this.landscape.isFoodLocation(this.getLocation())) {
            this.eatFood();
            this.landscape.removeFoodLocation(this.getLocation());
        }
    }

    public void eatFood() {
        if (this.timesteps >= this.maxTimesteps) {
            return;
        }
        ++this.foodEaten;
    }

    public Point getLocation() {
        return new Point(this.xLocation, this.yLocation);
    }

    public void setLocation(int x, int y) {
        this.xLocation = x;
        this.yLocation = y;
    }

    public int getMoves() {
        return this.timesteps;
    }

    public int getFoodEaten() {
        return this.foodEaten;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public boolean isFoodAhead() {
        Point ahead = this.landscape.getNextLocation(this.getLocation(), this.getOrientation());
        return this.landscape.isFoodLocation(ahead);
    }

    public void skip() {
        ++this.timesteps;
    }

    public int getMaxMoves() {
        return this.maxTimesteps;
    }

    public String toString() {
        return String.valueOf(this.xLocation) + ":" + this.yLocation + " Facing " + (Object)((Object)this.orientation) + " --- moves = " + this.timesteps;
    }
}

