/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.op.selection;

import com.epochx.core.GPModel;
import com.epochx.op.selection.PoolSelector;
import com.epochx.op.selection.ProgramSelector;
import com.epochx.op.selection.RandomSelector;
import com.epochx.representation.CandidateProgram;
import java.util.ArrayList;
import java.util.List;

public class TournamentSelector<TYPE>
implements ProgramSelector<TYPE>,
PoolSelector<TYPE> {
    private GPModel<TYPE> model;
    private int tournamentSize;
    private RandomSelector<TYPE> randomSelector;

    public TournamentSelector(GPModel<TYPE> model, int tournamentSize) {
        this.model = model;
        this.tournamentSize = tournamentSize;
        this.randomSelector = new RandomSelector<TYPE>(model);
    }

    @Override
    public void setSelectionPool(List<CandidateProgram<TYPE>> pop) {
        this.randomSelector.setSelectionPool(pop);
    }

    @Override
    public CandidateProgram<TYPE> getProgram() {
        CandidateProgram[] tournament = new CandidateProgram[this.tournamentSize];
        int i = 0;
        while (i < this.tournamentSize) {
            tournament[i] = this.randomSelector.getProgram();
            ++i;
        }
        double bestFitness = Double.POSITIVE_INFINITY;
        CandidateProgram bestProgram = null;
        CandidateProgram[] candidateProgramArray = tournament;
        int n = tournament.length;
        int n2 = 0;
        while (n2 < n) {
            CandidateProgram p = candidateProgramArray[n2];
            double fitness = p.getFitness();
            if (fitness < bestFitness) {
                bestFitness = fitness;
                bestProgram = p;
            }
            ++n2;
        }
        return bestProgram;
    }

    @Override
    public List<CandidateProgram<TYPE>> getPool(List<CandidateProgram<TYPE>> pop, int poolSize) {
        if (poolSize <= 0) {
            return pop;
        }
        ArrayList<CandidateProgram<TYPE>> pool = new ArrayList<CandidateProgram<TYPE>>(poolSize);
        TournamentSelector<TYPE> programSelector = new TournamentSelector<TYPE>(this.model, this.tournamentSize);
        programSelector.setSelectionPool(pop);
        int i = 0;
        while (i < poolSize) {
            pool.add(programSelector.getProgram());
            ++i;
        }
        return pool;
    }
}

