/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.op.mutation;

import com.epochx.core.GPModel;
import com.epochx.op.initialisation.GrowInitialiser;
import com.epochx.op.mutation.Mutation;
import com.epochx.representation.CandidateProgram;
import com.epochx.representation.Node;

public class SubtreeMutation<TYPE>
implements Mutation<TYPE> {
    private GPModel<TYPE> model;
    private int maxSubtreeDepth;

    public SubtreeMutation(GPModel<TYPE> model) {
        this(model, 4);
    }

    public SubtreeMutation(GPModel<TYPE> model, int maxSubtreeDepth) {
        this.model = model;
        this.maxSubtreeDepth = maxSubtreeDepth;
    }

    @Override
    public CandidateProgram<TYPE> mutate(CandidateProgram<TYPE> program) {
        int length = program.getProgramLength();
        int mutationPoint = this.model.getRNG().nextInt(length);
        GrowInitialiser<TYPE> init = new GrowInitialiser<TYPE>(this.model);
        Node<TYPE> subtree = init.buildGrowNodeTree(this.maxSubtreeDepth);
        program.setNthNode(mutationPoint, subtree);
        return program;
    }
}

