/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.op.initialisation;

import com.epochx.core.GPModel;
import com.epochx.op.initialisation.FullInitialiser;
import com.epochx.op.initialisation.GrowInitialiser;
import com.epochx.op.initialisation.Initialiser;
import com.epochx.representation.CandidateProgram;
import com.epochx.representation.Node;
import java.util.ArrayList;
import java.util.List;

public class RampedHalfAndHalfInitialiser<TYPE>
implements Initialiser<TYPE> {
    private GPModel<TYPE> model;
    private GrowInitialiser<TYPE> grow;
    private FullInitialiser<TYPE> full;

    public RampedHalfAndHalfInitialiser(GPModel<TYPE> model) {
        this.model = model;
        this.grow = new GrowInitialiser<TYPE>(model);
        this.full = new FullInitialiser<TYPE>(model);
    }

    @Override
    public List<CandidateProgram<TYPE>> getInitialPopulation() {
        int popSize = this.model.getPopulationSize();
        ArrayList<CandidateProgram<TYPE>> firstGen = new ArrayList<CandidateProgram<TYPE>>(popSize);
        int startDepth = 2;
        int endDepth = this.model.getInitialMaxDepth();
        if (endDepth < 2) {
            throw new IllegalArgumentException("Initial maximum depth must be greater than 1 for RH+H.");
        }
        double programsPerDepth = (double)popSize / (double)(endDepth - startDepth + 1);
        int i = 0;
        while (i < popSize) {
            Node<TYPE> rootNode;
            CandidateProgram<TYPE> program;
            int depth = (int)Math.floor((double)firstGen.size() / programsPerDepth + (double)startDepth);
            while (firstGen.contains(program = new CandidateProgram<TYPE>(rootNode = i % 2 == 0 ? this.grow.buildGrowNodeTree(depth) : this.full.buildFullNodeTree(depth), this.model))) {
            }
            firstGen.add(program);
            ++i;
        }
        return firstGen;
    }
}

