/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.op.crossover;

import com.epochx.core.GPController;
import com.epochx.core.GPModel;
import com.epochx.life.GenerationListener;
import com.epochx.op.crossover.Crossover;
import com.epochx.random.RandomNumberGenerator;
import com.epochx.representation.CandidateProgram;
import com.epochx.representation.Node;

public class UniformPointCrossover<TYPE>
implements Crossover<TYPE>,
GenerationListener {
    private GPModel<TYPE> model;
    private RandomNumberGenerator rng;

    public UniformPointCrossover(GPModel<TYPE> model) {
        this.model = model;
        GPController.getLifeCycleManager().addGenerationListener(this);
    }

    @Override
    public CandidateProgram<TYPE>[] crossover(CandidateProgram<TYPE> program1, CandidateProgram<TYPE> program2) {
        int swapPoint1 = this.rng.nextInt(program1.getProgramLength());
        int swapPoint2 = this.rng.nextInt(program2.getProgramLength());
        Node<TYPE> subTree1 = program1.getNthNode(swapPoint1);
        Node<TYPE> subTree2 = program2.getNthNode(swapPoint2);
        program1.setNthNode(swapPoint1, subTree2);
        program2.setNthNode(swapPoint2, subTree1);
        return new CandidateProgram[]{program1, program2};
    }

    @Override
    public void onGenerationStart() {
        this.rng = this.model.getRNG();
    }
}

