/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.core;

import com.epochx.life.LifeCycleListener;
import com.epochx.op.crossover.Crossover;
import com.epochx.op.initialisation.Initialiser;
import com.epochx.op.mutation.Mutation;
import com.epochx.op.selection.PoolSelector;
import com.epochx.op.selection.ProgramSelector;
import com.epochx.random.RandomNumberGenerator;
import com.epochx.representation.CandidateProgram;
import com.epochx.representation.FunctionNode;
import com.epochx.representation.Node;
import com.epochx.representation.TerminalNode;
import com.epochx.stats.CrossoverStatListener;
import com.epochx.stats.GenerationStatListener;
import com.epochx.stats.MutationStatListener;
import com.epochx.stats.RunStatListener;
import java.util.List;

public interface GPModel<TYPE> {
    public Initialiser<TYPE> getInitialiser();

    public Crossover<TYPE> getCrossover();

    public Mutation<TYPE> getMutator();

    public ProgramSelector<TYPE> getProgramSelector();

    public PoolSelector<TYPE> getPoolSelector();

    public List<TerminalNode<TYPE>> getTerminals();

    public List<FunctionNode<TYPE>> getFunctions();

    public List<Node<TYPE>> getSyntax();

    public RandomNumberGenerator getRNG();

    public int getNoRuns();

    public int getNoGenerations();

    public int getPopulationSize();

    public int getPoolSize();

    public int getNoElites();

    public int getInitialMaxDepth();

    public int getMaxProgramDepth();

    public double getCrossoverProbability();

    public double getMutationProbability();

    public double getReproductionProbability();

    public double getFitness(CandidateProgram<TYPE> var1);

    public double getTerminationFitness();

    public boolean acceptCrossover(CandidateProgram<TYPE>[] var1, CandidateProgram<TYPE>[] var2);

    public boolean acceptMutation(CandidateProgram<TYPE> var1, CandidateProgram<TYPE> var2);

    public RunStatListener getRunStatListener();

    public GenerationStatListener getGenerationStatListener();

    public CrossoverStatListener getCrossoverStatListener();

    public MutationStatListener getMutationStatListener();

    public LifeCycleListener<TYPE> getLifeCycleListener();
}

