/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.core;

import com.epochx.core.GPController;
import com.epochx.core.GPCrossover;
import com.epochx.core.GPElitism;
import com.epochx.core.GPModel;
import com.epochx.core.GPMutation;
import com.epochx.core.GPPoolSelection;
import com.epochx.core.GPReproduction;
import com.epochx.life.LifeCycleManager;
import com.epochx.random.RandomNumberGenerator;
import com.epochx.representation.CandidateProgram;
import java.util.ArrayList;
import java.util.List;

public class GPGeneration<TYPE> {
    private GPModel<TYPE> model;
    private LifeCycleManager<TYPE> lifeCycle;
    private GPElitism<TYPE> elitism;
    private GPPoolSelection<TYPE> poolSelection;
    private GPCrossover<TYPE> crossover;
    private GPMutation<TYPE> mutation;
    private GPReproduction<TYPE> reproduction;
    private List<CandidateProgram<TYPE>> pop;
    private RandomNumberGenerator rng;
    private double mutationProbability;
    private double crossoverProbability;

    public GPGeneration(GPModel<TYPE> model) {
        this.model = model;
        this.lifeCycle = GPController.getLifeCycleManager();
        this.elitism = new GPElitism<TYPE>(model);
        this.poolSelection = new GPPoolSelection<TYPE>(model);
        this.crossover = new GPCrossover<TYPE>(model);
        this.mutation = new GPMutation<TYPE>(model);
        this.reproduction = new GPReproduction<TYPE>(model);
    }

    private void initialise() {
        this.rng = this.model.getRNG();
        this.mutationProbability = this.model.getMutationProbability();
        this.crossoverProbability = this.model.getCrossoverProbability();
    }

    public List<CandidateProgram<TYPE>> generation(List<CandidateProgram<TYPE>> previousPop) {
        this.initialise();
        this.lifeCycle.onGenerationStart();
        int popSize = this.model.getPopulationSize();
        this.pop = new ArrayList<CandidateProgram<TYPE>>(popSize);
        this.pop.addAll(this.elitism.getElites(previousPop));
        List<CandidateProgram<TYPE>> pool = this.poolSelection.getPool(previousPop);
        this.model.getProgramSelector().setSelectionPool(pool);
        while (this.pop.size() < popSize) {
            double random = this.rng.nextDouble();
            if (random < this.crossoverProbability) {
                CandidateProgram<TYPE>[] children;
                CandidateProgram<TYPE>[] candidateProgramArray = children = this.crossover.crossover();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    CandidateProgram<TYPE> c = candidateProgramArray[n2];
                    if (this.pop.size() < popSize) {
                        this.pop.add(c);
                    }
                    ++n2;
                }
                continue;
            }
            if (random < this.crossoverProbability + this.mutationProbability) {
                this.pop.add(this.mutation.mutate());
                continue;
            }
            this.pop.add(this.reproduction.reproduce());
        }
        return this.pop;
    }
}

