/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.core;

import com.epochx.core.GPController;
import com.epochx.core.GPModel;
import com.epochx.life.GenerationListener;
import com.epochx.life.LifeCycleManager;
import com.epochx.op.crossover.Crossover;
import com.epochx.op.selection.ProgramSelector;
import com.epochx.representation.CandidateProgram;
import com.epochx.stats.CrossoverStats;

public class GPCrossover<TYPE>
implements GenerationListener {
    private GPModel<TYPE> model;
    private LifeCycleManager<TYPE> lifeCycle;
    private ProgramSelector<TYPE> programSelector;
    private Crossover<TYPE> crossover;
    private CrossoverStats<TYPE> crossoverStats;
    private int maxProgramDepth;
    private int reversions;

    public GPCrossover(GPModel<TYPE> model) {
        this.model = model;
        this.lifeCycle = GPController.getLifeCycleManager();
        this.lifeCycle.addGenerationListener(this);
        this.crossoverStats = new CrossoverStats();
        this.crossoverStats.addCrossoverStatListener(model.getCrossoverStatListener());
        this.initialise();
    }

    private void initialise() {
        this.maxProgramDepth = this.model.getMaxProgramDepth();
        this.programSelector = this.model.getProgramSelector();
        this.crossover = this.model.getCrossover();
    }

    public CandidateProgram<TYPE>[] crossover() {
        long crossoverStartTime = System.nanoTime();
        CandidateProgram[] parents = null;
        CandidateProgram[] children = null;
        this.reversions = -1;
        do {
            CandidateProgram<TYPE> parent1 = this.programSelector.getProgram();
            CandidateProgram<TYPE> parent2 = this.programSelector.getProgram();
            CandidateProgram clone1 = (CandidateProgram)parent1.clone();
            CandidateProgram clone2 = (CandidateProgram)parent2.clone();
            parents = new CandidateProgram[]{parent1, parent2};
            children = this.crossover.crossover(clone1, clone2);
            children = this.lifeCycle.onCrossover(parents, children);
            ++this.reversions;
        } while (children == null);
        int replacement = 0;
        int i = 0;
        while (i < children.length) {
            if (children[i].getProgramDepth() > this.maxProgramDepth) {
                if (replacement >= parents.length) {
                    replacement = 0;
                }
                children[i] = (CandidateProgram)parents[replacement].clone();
                ++replacement;
            }
            ++i;
        }
        long runtime = System.nanoTime() - crossoverStartTime;
        this.crossoverStats.addCrossover(parents, children, runtime, this.reversions);
        return children;
    }

    public int getRevertedCount() {
        return this.reversions;
    }

    @Override
    public void onGenerationStart() {
        this.initialise();
    }
}

