/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.core;

import com.epochx.core.GPModel;
import com.epochx.core.GPRun;
import com.epochx.life.LifeCycleManager;
import com.epochx.stats.RunStats;

public class GPController<TYPE> {
    private static GPController<?> controller;
    private LifeCycleManager<TYPE> lifeCycle = new LifeCycleManager();

    private GPController() {
    }

    public static <TYPE> GPRun<TYPE>[] run(GPModel<TYPE> model) {
        if (controller == null) {
            controller = new GPController<TYPE>();
        }
        GPRun[] runs = new GPRun[model.getNoRuns()];
        RunStats runStats = new RunStats();
        runStats.addRunStatListener(model.getRunStatListener());
        int i = 0;
        while (i < model.getNoRuns()) {
            runs[i] = GPRun.run(model);
            runStats.addRun(runs[i], i + 1);
            ++i;
        }
        return runs;
    }

    public static <TYPE> LifeCycleManager<TYPE> getLifeCycleManager() {
        if (controller == null) {
            controller = new GPController<TYPE>();
        }
        return GPController.controller.lifeCycle;
    }
}

