/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.core;

import com.epochx.core.GPModel;
import com.epochx.life.LifeCycleListener;
import com.epochx.op.crossover.Crossover;
import com.epochx.op.crossover.UniformPointCrossover;
import com.epochx.op.initialisation.FullInitialiser;
import com.epochx.op.initialisation.Initialiser;
import com.epochx.op.mutation.Mutation;
import com.epochx.op.mutation.SubtreeMutation;
import com.epochx.op.selection.PoolSelector;
import com.epochx.op.selection.ProgramSelector;
import com.epochx.op.selection.RandomSelector;
import com.epochx.op.selection.TournamentSelector;
import com.epochx.random.MersenneTwisterFast;
import com.epochx.random.RandomNumberGenerator;
import com.epochx.representation.CandidateProgram;
import com.epochx.representation.Node;
import com.epochx.stats.CrossoverStatField;
import com.epochx.stats.CrossoverStatListener;
import com.epochx.stats.GenerationStatField;
import com.epochx.stats.GenerationStatListener;
import com.epochx.stats.MutationStatField;
import com.epochx.stats.MutationStatListener;
import com.epochx.stats.RunStatField;
import com.epochx.stats.RunStatListener;
import java.util.ArrayList;
import java.util.List;

public abstract class GPAbstractModel<TYPE>
implements GPModel<TYPE>,
GenerationStatListener,
RunStatListener,
CrossoverStatListener,
MutationStatListener,
LifeCycleListener<TYPE> {
    private Initialiser<TYPE> initialiser;
    private Crossover<TYPE> crossover;
    private Mutation<TYPE> mutator;
    private PoolSelector<TYPE> poolSelector;
    private ProgramSelector<TYPE> programSelector;
    private RandomNumberGenerator randomNumberGenerator;
    private int noRuns = 1;
    private int noGenerations = 50;
    private int populationSize = 500;
    private int poolSize = 50;
    private int noElites = 10;
    private int maxInitialDepth = 6;
    private int maxProgramDepth = 17;
    private double terminationFitness = 0.0;
    private double crossoverProbability = 0.9;
    private double mutationProbability = 0.0;
    private MutationStatField[] mutationStatFields = null;
    private CrossoverStatField[] crossoverStatFields = null;
    private GenerationStatField[] generationStatFields = null;
    private RunStatField[] runStatFields = null;
    private RunStatListener runStatListener = this;
    private GenerationStatListener generationStatListener = this;
    private CrossoverStatListener crossoverStatListener = this;
    private MutationStatListener mutationStatListener = this;
    private LifeCycleListener<TYPE> lifeCycleListener = this;

    public GPAbstractModel() {
        this.programSelector = new RandomSelector(this);
        this.poolSelector = new TournamentSelector(this, 3);
        this.initialiser = new FullInitialiser(this);
        this.crossover = new UniformPointCrossover(this);
        this.mutator = new SubtreeMutation(this);
        this.randomNumberGenerator = new MersenneTwisterFast();
    }

    @Override
    public Initialiser<TYPE> getInitialiser() {
        return this.initialiser;
    }

    public void setInitialiser(Initialiser<TYPE> initialiser) {
        this.initialiser = initialiser;
    }

    @Override
    public Crossover<TYPE> getCrossover() {
        return this.crossover;
    }

    public void setCrossover(Crossover<TYPE> crossover) {
        this.crossover = crossover;
    }

    @Override
    public Mutation<TYPE> getMutator() {
        return this.mutator;
    }

    public void setMutator(Mutation<TYPE> mutator) {
        this.mutator = mutator;
    }

    @Override
    public ProgramSelector<TYPE> getProgramSelector() {
        return this.programSelector;
    }

    public void setProgramSelector(ProgramSelector<TYPE> programSelector) {
        this.programSelector = programSelector;
    }

    @Override
    public PoolSelector<TYPE> getPoolSelector() {
        return this.poolSelector;
    }

    public void setPoolSelector(PoolSelector<TYPE> poolSelector) {
        this.poolSelector = poolSelector;
    }

    @Override
    public List<Node<TYPE>> getSyntax() {
        ArrayList<Node<TYPE>> syntax = new ArrayList<Node<TYPE>>(this.getTerminals());
        syntax.addAll(this.getFunctions());
        return syntax;
    }

    @Override
    public RandomNumberGenerator getRNG() {
        return this.randomNumberGenerator;
    }

    public void setRNG(RandomNumberGenerator rng) {
        this.randomNumberGenerator = rng;
    }

    @Override
    public int getNoRuns() {
        return this.noRuns;
    }

    public void setNoRuns(int noRuns) {
        this.noRuns = noRuns;
    }

    @Override
    public int getNoGenerations() {
        return this.noGenerations;
    }

    public void setNoGenerations(int noGenerations) {
        this.noGenerations = noGenerations;
    }

    @Override
    public int getPopulationSize() {
        return this.populationSize;
    }

    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    @Override
    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    @Override
    public int getNoElites() {
        return this.noElites;
    }

    public void setNoElites(int noElites) {
        this.noElites = noElites;
    }

    @Override
    public int getInitialMaxDepth() {
        return this.maxInitialDepth;
    }

    public void setInitialMaxDepth(int maxInitialDepth) {
        this.maxInitialDepth = maxInitialDepth;
    }

    @Override
    public int getMaxProgramDepth() {
        return this.maxProgramDepth;
    }

    public void setMaxProgramDepth(int maxDepth) {
        this.maxProgramDepth = maxDepth;
    }

    @Override
    public double getCrossoverProbability() {
        return this.crossoverProbability;
    }

    public void setCrossoverProbability(double crossoverProbability) {
        this.crossoverProbability = crossoverProbability;
    }

    @Override
    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public void setMutationProbability(double mutationProbability) {
        this.mutationProbability = mutationProbability;
    }

    @Override
    public double getReproductionProbability() {
        return 1.0 - (this.getCrossoverProbability() + this.getMutationProbability());
    }

    @Override
    public double getTerminationFitness() {
        return this.terminationFitness;
    }

    public void setTerminationFitness(double terminationFitness) {
        this.terminationFitness = terminationFitness;
    }

    @Override
    public boolean acceptCrossover(CandidateProgram<TYPE>[] parents, CandidateProgram<TYPE>[] children) {
        return true;
    }

    @Override
    public boolean acceptMutation(CandidateProgram<TYPE> parent, CandidateProgram<TYPE> child) {
        return true;
    }

    @Override
    public RunStatListener getRunStatListener() {
        return this.runStatListener;
    }

    public void setRunStatListener(RunStatListener runStatListener) {
        this.runStatListener = runStatListener;
    }

    @Override
    public GenerationStatListener getGenerationStatListener() {
        return this.generationStatListener;
    }

    public void setGenerationStatListener(GenerationStatListener generationStatListener) {
        this.generationStatListener = generationStatListener;
    }

    @Override
    public CrossoverStatListener getCrossoverStatListener() {
        return this.crossoverStatListener;
    }

    public void setCrossoverStatListener(CrossoverStatListener crossoverStatListener) {
        this.crossoverStatListener = crossoverStatListener;
    }

    @Override
    public MutationStatListener getMutationStatListener() {
        return this.mutationStatListener;
    }

    public void setMutationStatListener(MutationStatListener mutationStatListener) {
        this.mutationStatListener = mutationStatListener;
    }

    @Override
    public RunStatField[] getRunStatFields() {
        return this.runStatFields;
    }

    public void setRunStatFields(RunStatField[] runStatFields) {
        this.runStatFields = runStatFields;
    }

    @Override
    public void runStats(int runNo, Object[] stats) {
        if (stats.length > 0) {
            System.out.print(String.valueOf(runNo) + "\t");
            Object[] objectArray = stats;
            int n = stats.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                System.out.print(o + "\t");
                ++n2;
            }
            System.out.println();
        }
    }

    @Override
    public GenerationStatField[] getGenStatFields() {
        return this.generationStatFields;
    }

    public void setGenStatFields(GenerationStatField[] generationStatFields) {
        this.generationStatFields = generationStatFields;
    }

    @Override
    public void generationStats(int generation, Object[] stats) {
        if (stats.length > 0) {
            System.out.print(String.valueOf(generation) + "\t");
            Object[] objectArray = stats;
            int n = stats.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                System.out.print(o + "\t");
                ++n2;
            }
            System.out.println();
        }
    }

    @Override
    public CrossoverStatField[] getCrossoverStatFields() {
        return this.crossoverStatFields;
    }

    public void setCrossoverStatFields(CrossoverStatField[] crossoverStatFields) {
        this.crossoverStatFields = crossoverStatFields;
    }

    @Override
    public void crossoverStats(Object[] stats) {
    }

    @Override
    public MutationStatField[] getMutationStatFields() {
        return this.mutationStatFields;
    }

    public void setMutationStatFields(MutationStatField[] mutationStatFields) {
        this.mutationStatFields = mutationStatFields;
    }

    @Override
    public void mutationStats(Object[] stats) {
    }

    @Override
    public LifeCycleListener<TYPE> getLifeCycleListener() {
        return this.lifeCycleListener;
    }

    public void setLifeCycleListener(LifeCycleListener<TYPE> lifeCycleListener) {
        this.lifeCycleListener = lifeCycleListener;
    }

    @Override
    public List<CandidateProgram<TYPE>> onInitialisation(List<CandidateProgram<TYPE>> pop) {
        return pop;
    }

    @Override
    public List<CandidateProgram<TYPE>> onElitism(List<CandidateProgram<TYPE>> elites) {
        return elites;
    }

    @Override
    public List<CandidateProgram<TYPE>> onPoolSelection(List<CandidateProgram<TYPE>> pool) {
        return pool;
    }

    @Override
    public CandidateProgram<TYPE>[] onCrossover(CandidateProgram<TYPE>[] parents, CandidateProgram<TYPE>[] children) {
        return children;
    }

    @Override
    public CandidateProgram<TYPE> onMutation(CandidateProgram<TYPE> parent, CandidateProgram<TYPE> child) {
        return child;
    }

    @Override
    public CandidateProgram<TYPE> onReproduction(CandidateProgram<TYPE> child) {
        return child;
    }

    @Override
    public void onGenerationStart() {
    }

    @Override
    public void onFitnessTermination() {
    }

    @Override
    public void onGenerationTermination() {
    }
}

