/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.stats;

import com.epochx.representation.CandidateProgram;
import com.epochx.stats.GenerationStatField;
import com.epochx.stats.GenerationStatListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenerationStats<TYPE> {
    public List<GenerationStatListener> listeners = new ArrayList<GenerationStatListener>();
    private long previousGenTime;

    public void setStartTime() {
        this.previousGenTime = System.nanoTime();
    }

    public void addGenerationStatListener(GenerationStatListener listener) {
        this.listeners.add(listener);
    }

    public void removeGenerationStatListener(GenerationStatListener listener) {
        this.listeners.remove(listener);
    }

    public void addGen(List<CandidateProgram<TYPE>> pop, int gen) {
        HashMap<GenerationStatField, Object> stats = new HashMap<GenerationStatField, Object>();
        HashMap<GenerationStatListener, GenerationStatField[]> requestedStats = new HashMap<GenerationStatListener, GenerationStatField[]>();
        for (GenerationStatListener l : this.listeners) {
            GenerationStatField[] fields = l.getGenStatFields();
            if (fields == null) {
                fields = new GenerationStatField[]{};
            }
            requestedStats.put(l, fields);
            GenerationStatField[] generationStatFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Object sf = generationStatFieldArray[n2];
                if (!stats.containsKey(sf)) {
                    stats.put((GenerationStatField)((Object)sf), "");
                }
                ++n2;
            }
        }
        long runtime = 0L;
        long currentTime = System.nanoTime();
        if (this.previousGenTime != -1L) {
            runtime = currentTime - this.previousGenTime;
        }
        this.previousGenTime = currentTime;
        this.gatherStats(stats, pop, runtime);
        Set ls = requestedStats.keySet();
        for (GenerationStatListener l : ls) {
            GenerationStatField[] statFields = (GenerationStatField[])requestedStats.get(l);
            Object[] statResults = new Object[statFields.length];
            int i = 0;
            while (i < statFields.length) {
                statResults[i] = stats.get((Object)statFields[i]);
                ++i;
            }
            l.generationStats(gen, statResults);
        }
    }

    private void gatherStats(Map<GenerationStatField, Object> stats, List<CandidateProgram<TYPE>> pop, long runtime) {
        this.gatherDepthStats(stats, pop);
        this.gatherLengthStats(stats, pop);
        this.gatherTerminalStats(stats, pop);
        this.gatherDistinctTerminalStats(stats, pop);
        this.gatherFunctionStats(stats, pop);
        this.gatherDistinctFunctionStats(stats, pop);
        this.gatherFitnessStats(stats, pop);
        if (stats.containsKey((Object)GenerationStatField.POPULATION)) {
            stats.put(GenerationStatField.POPULATION, pop);
        }
        if (stats.containsKey((Object)GenerationStatField.RUN_TIME)) {
            stats.put(GenerationStatField.RUN_TIME, runtime);
        }
    }

    private void gatherDepthStats(Map<GenerationStatField, Object> stats, List<CandidateProgram<TYPE>> pop) {
        if (stats.containsKey((Object)GenerationStatField.DEPTH_AVE) || stats.containsKey((Object)GenerationStatField.DEPTH_STDEV) || stats.containsKey((Object)GenerationStatField.DEPTH_MAX) || stats.containsKey((Object)GenerationStatField.DEPTH_MIN) || stats.containsKey((Object)GenerationStatField.AVE_NODES_PER_DEPTH)) {
            double[] depths = new double[pop.size()];
            int i = 0;
            while (i < pop.size()) {
                depths[i] = pop.get(i).getProgramDepth();
                ++i;
            }
            if (stats.containsKey((Object)GenerationStatField.DEPTH_AVE)) {
                stats.put(GenerationStatField.DEPTH_AVE, new Double(this.ave(depths)));
            }
            if (stats.containsKey((Object)GenerationStatField.DEPTH_STDEV)) {
                stats.put(GenerationStatField.DEPTH_STDEV, new Double(this.stdev(depths)));
            }
            if (stats.containsKey((Object)GenerationStatField.DEPTH_MAX)) {
                stats.put(GenerationStatField.DEPTH_MAX, new Double(this.max(depths)));
            }
            if (stats.containsKey((Object)GenerationStatField.DEPTH_MIN)) {
                stats.put(GenerationStatField.DEPTH_MIN, new Double(this.min(depths)));
            }
            if (stats.containsKey((Object)GenerationStatField.AVE_NODES_PER_DEPTH)) {
                stats.put(GenerationStatField.AVE_NODES_PER_DEPTH, this.getAveNodesPerDepth(pop));
            }
        }
    }

    private double[] getAveNodesPerDepth(List<CandidateProgram<TYPE>> pop) {
        int maxDepth = 0;
        for (CandidateProgram<TYPE> program : pop) {
            int depth = program.getProgramDepth();
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        double[] aveNodes = new double[maxDepth];
        int d = 0;
        while (d < maxDepth) {
            double[] noNodes = new double[pop.size()];
            int j = 0;
            while (j < pop.size()) {
                noNodes[j] = pop.get(j).getNodesAtDepth(d).size();
                ++j;
            }
            aveNodes[d] = this.ave(noNodes);
            ++d;
        }
        return aveNodes;
    }

    private void gatherLengthStats(Map<GenerationStatField, Object> stats, List<CandidateProgram<TYPE>> pop) {
        if (stats.containsKey((Object)GenerationStatField.LENGTH_AVE) || stats.containsKey((Object)GenerationStatField.LENGTH_STDEV) || stats.containsKey((Object)GenerationStatField.LENGTH_MAX) || stats.containsKey((Object)GenerationStatField.LENGTH_MIN)) {
            double[] lengths = new double[pop.size()];
            int i = 0;
            while (i < pop.size()) {
                lengths[i] = pop.get(i).getProgramLength();
                ++i;
            }
            if (stats.containsKey((Object)GenerationStatField.LENGTH_AVE)) {
                stats.put(GenerationStatField.LENGTH_AVE, new Double(this.ave(lengths)));
            }
            if (stats.containsKey((Object)GenerationStatField.LENGTH_STDEV)) {
                stats.put(GenerationStatField.LENGTH_STDEV, new Double(this.stdev(lengths)));
            }
            if (stats.containsKey((Object)GenerationStatField.LENGTH_MAX)) {
                stats.put(GenerationStatField.LENGTH_MAX, new Double(this.max(lengths)));
            }
            if (stats.containsKey((Object)GenerationStatField.LENGTH_MIN)) {
                stats.put(GenerationStatField.LENGTH_MIN, new Double(this.min(lengths)));
            }
        }
    }

    private void gatherTerminalStats(Map<GenerationStatField, Object> stats, List<CandidateProgram<TYPE>> pop) {
        if (stats.containsKey((Object)GenerationStatField.NO_TERMINALS_AVE) || stats.containsKey((Object)GenerationStatField.NO_TERMINALS_STDEV) || stats.containsKey((Object)GenerationStatField.NO_TERMINALS_MAX) || stats.containsKey((Object)GenerationStatField.NO_TERMINALS_MIN)) {
            double[] noTerminals = new double[pop.size()];
            int i = 0;
            while (i < pop.size()) {
                noTerminals[i] = pop.get(i).getNoTerminals();
                ++i;
            }
            if (stats.containsKey((Object)GenerationStatField.NO_TERMINALS_AVE)) {
                stats.put(GenerationStatField.NO_TERMINALS_AVE, new Double(this.ave(noTerminals)));
            }
            if (stats.containsKey((Object)GenerationStatField.NO_TERMINALS_STDEV)) {
                stats.put(GenerationStatField.NO_TERMINALS_STDEV, new Double(this.stdev(noTerminals)));
            }
            if (stats.containsKey((Object)GenerationStatField.NO_TERMINALS_MAX)) {
                stats.put(GenerationStatField.NO_TERMINALS_MAX, new Double(this.max(noTerminals)));
            }
            if (stats.containsKey((Object)GenerationStatField.NO_TERMINALS_MIN)) {
                stats.put(GenerationStatField.NO_TERMINALS_MIN, new Double(this.min(noTerminals)));
            }
        }
    }

    private void gatherDistinctTerminalStats(Map<GenerationStatField, Object> stats, List<CandidateProgram<TYPE>> pop) {
        if (stats.containsKey((Object)GenerationStatField.NO_DISTINCT_TERMINALS_AVE) || stats.containsKey((Object)GenerationStatField.NO_DISTINCT_TERMINALS_STDEV) || stats.containsKey((Object)GenerationStatField.NO_DISTINCT_TERMINALS_MAX) || stats.containsKey((Object)GenerationStatField.NO_DISTINCT_TERMINALS_MIN)) {
            double[] noDTerminals = new double[pop.size()];
            int i = 0;
            while (i < pop.size()) {
                noDTerminals[i] = pop.get(i).getNoDistinctTerminals();
                ++i;
            }
            if (stats.containsKey((Object)GenerationStatField.NO_DISTINCT_TERMINALS_AVE)) {
                stats.put(GenerationStatField.NO_DISTINCT_TERMINALS_AVE, new Double(this.ave(noDTerminals)));
            }
            if (stats.containsKey((Object)GenerationStatField.NO_DISTINCT_TERMINALS_STDEV)) {
                stats.put(GenerationStatField.NO_DISTINCT_TERMINALS_STDEV, new Double(this.stdev(noDTerminals)));
            }
            if (stats.containsKey((Object)GenerationStatField.NO_DISTINCT_TERMINALS_MAX)) {
                stats.put(GenerationStatField.NO_DISTINCT_TERMINALS_MAX, new Double(this.max(noDTerminals)));
            }
            if (stats.containsKey((Object)GenerationStatField.NO_DISTINCT_TERMINALS_MIN)) {
                stats.put(GenerationStatField.NO_DISTINCT_TERMINALS_MIN, new Double(this.min(noDTerminals)));
            }
        }
    }

    private void gatherFunctionStats(Map<GenerationStatField, Object> stats, List<CandidateProgram<TYPE>> pop) {
        if (stats.containsKey((Object)GenerationStatField.NO_FUNCTIONS_AVE) || stats.containsKey((Object)GenerationStatField.NO_FUNCTIONS_STDEV) || stats.containsKey((Object)GenerationStatField.NO_FUNCTIONS_MAX) || stats.containsKey((Object)GenerationStatField.NO_FUNCTIONS_MIN)) {
            double[] noFunctions = new double[pop.size()];
            int i = 0;
            while (i < pop.size()) {
                noFunctions[i] = pop.get(i).getNoFunctions();
                ++i;
            }
            if (stats.containsKey((Object)GenerationStatField.NO_FUNCTIONS_AVE)) {
                stats.put(GenerationStatField.NO_FUNCTIONS_AVE, new Double(this.ave(noFunctions)));
            }
            if (stats.containsKey((Object)GenerationStatField.NO_FUNCTIONS_STDEV)) {
                stats.put(GenerationStatField.NO_FUNCTIONS_STDEV, new Double(this.stdev(noFunctions)));
            }
            if (stats.containsKey((Object)GenerationStatField.NO_FUNCTIONS_MAX)) {
                stats.put(GenerationStatField.NO_FUNCTIONS_MAX, new Double(this.max(noFunctions)));
            }
            if (stats.containsKey((Object)GenerationStatField.NO_FUNCTIONS_MIN)) {
                stats.put(GenerationStatField.NO_FUNCTIONS_MIN, new Double(this.min(noFunctions)));
            }
        }
    }

    private void gatherDistinctFunctionStats(Map<GenerationStatField, Object> stats, List<CandidateProgram<TYPE>> pop) {
        if (stats.containsKey((Object)GenerationStatField.NO_DISTINCT_FUNCTIONS_AVE) || stats.containsKey((Object)GenerationStatField.NO_DISTINCT_FUNCTIONS_STDEV) || stats.containsKey((Object)GenerationStatField.NO_DISTINCT_FUNCTIONS_MAX) || stats.containsKey((Object)GenerationStatField.NO_DISTINCT_FUNCTIONS_MIN)) {
            double[] noDFunctions = new double[pop.size()];
            int i = 0;
            while (i < pop.size()) {
                noDFunctions[i] = pop.get(i).getNoDistinctFunctions();
                ++i;
            }
            if (stats.containsKey((Object)GenerationStatField.NO_DISTINCT_FUNCTIONS_AVE)) {
                stats.put(GenerationStatField.NO_DISTINCT_FUNCTIONS_AVE, new Double(this.ave(noDFunctions)));
            }
            if (stats.containsKey((Object)GenerationStatField.NO_DISTINCT_FUNCTIONS_STDEV)) {
                stats.put(GenerationStatField.NO_DISTINCT_FUNCTIONS_STDEV, new Double(this.stdev(noDFunctions)));
            }
            if (stats.containsKey((Object)GenerationStatField.NO_DISTINCT_FUNCTIONS_MAX)) {
                stats.put(GenerationStatField.NO_DISTINCT_FUNCTIONS_MAX, new Double(this.max(noDFunctions)));
            }
            if (stats.containsKey((Object)GenerationStatField.NO_DISTINCT_FUNCTIONS_MIN)) {
                stats.put(GenerationStatField.NO_DISTINCT_FUNCTIONS_MIN, new Double(this.min(noDFunctions)));
            }
        }
    }

    private void gatherFitnessStats(Map<GenerationStatField, Object> stats, List<CandidateProgram<TYPE>> pop) {
        if (stats.containsKey((Object)GenerationStatField.FITNESS_AVE) || stats.containsKey((Object)GenerationStatField.FITNESS_STDEV) || stats.containsKey((Object)GenerationStatField.FITNESS_MAX) || stats.containsKey((Object)GenerationStatField.FITNESS_MIN) || stats.containsKey((Object)GenerationStatField.FITNESS_MEDIAN) || stats.containsKey((Object)GenerationStatField.BEST_PROGRAM) || stats.containsKey((Object)GenerationStatField.FITNESS_CI_95)) {
            double[] fitnesses = new double[pop.size()];
            int i = 0;
            while (i < pop.size()) {
                fitnesses[i] = pop.get(i).getFitness();
                ++i;
            }
            int maxIndex = -1;
            int minIndex = -1;
            double stdev = -1.0;
            if (stats.containsKey((Object)GenerationStatField.FITNESS_AVE)) {
                stats.put(GenerationStatField.FITNESS_AVE, new Double(this.ave(fitnesses)));
            }
            if (stats.containsKey((Object)GenerationStatField.FITNESS_STDEV)) {
                stdev = this.stdev(fitnesses);
                stats.put(GenerationStatField.FITNESS_STDEV, new Double(stdev));
            }
            if (stats.containsKey((Object)GenerationStatField.FITNESS_MAX)) {
                maxIndex = this.maxIndex(fitnesses);
                stats.put(GenerationStatField.FITNESS_MAX, new Double(fitnesses[maxIndex]));
            }
            if (stats.containsKey((Object)GenerationStatField.FITNESS_MIN)) {
                stats.put(GenerationStatField.FITNESS_MIN, new Double(this.min(fitnesses)));
            }
            if (stats.containsKey((Object)GenerationStatField.FITNESS_MEDIAN)) {
                stats.put(GenerationStatField.FITNESS_MEDIAN, new Double(this.median(fitnesses)));
            }
            if (stats.containsKey((Object)GenerationStatField.BEST_PROGRAM)) {
                if (minIndex == -1) {
                    minIndex = this.minIndex(fitnesses);
                }
                stats.put(GenerationStatField.BEST_PROGRAM, pop.get(minIndex));
            }
            if (stats.containsKey((Object)GenerationStatField.FITNESS_CI_95)) {
                if (stdev == -1.0) {
                    stdev = this.stdev(fitnesses);
                }
                double ci = 1.96 * (stdev / Math.sqrt(fitnesses.length));
                stats.put(GenerationStatField.FITNESS_CI_95, new Double(ci));
            }
        }
    }

    private double ave(double[] values) {
        double sum = 0.0;
        int i = 0;
        while (i < values.length) {
            sum += values[i];
            ++i;
        }
        return sum / (double)values.length;
    }

    private double stdev(double[] values) {
        return this.stdev(values, this.ave(values));
    }

    private double stdev(double[] values, double ave) {
        double sqDiff = 0.0;
        int i = 0;
        while (i < values.length) {
            sqDiff += Math.pow(values[i] - ave, 2.0);
            ++i;
        }
        return Math.sqrt(sqDiff / (double)values.length);
    }

    private double max(double[] values) {
        double max = 0.0;
        int i = 0;
        while (i < values.length) {
            max = values[i] > max ? values[i] : max;
            ++i;
        }
        return max;
    }

    private int maxIndex(double[] values) {
        double max = 0.0;
        int maxIndex = -1;
        int i = 0;
        while (i < values.length) {
            if (values[i] > max) {
                max = values[i];
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    private double min(double[] values) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            min = values[i] < min ? values[i] : min;
            ++i;
        }
        return min;
    }

    private int minIndex(double[] values) {
        double min = Double.MAX_VALUE;
        int minIndex = -1;
        int i = 0;
        while (i < values.length) {
            if (values[i] < min) {
                min = values[i];
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    private double median(double[] values) {
        Arrays.sort(values);
        int medianIndex = (int)Math.floor(values.length / 2);
        double median = values[medianIndex - 1];
        if (values.length % 2 == 0) {
            median += values[medianIndex];
            median /= 2.0;
        }
        return median;
    }
}

