/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.representation;

import com.epochx.representation.FunctionNode;
import com.epochx.representation.TerminalNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class Node<TYPE>
implements Cloneable {
    private Node<TYPE>[] children;

    public Node(Node<TYPE> ... children) {
        this.children = children;
    }

    public abstract TYPE evaluate();

    public Node<TYPE>[] getChildren() {
        return this.children;
    }

    public void setChildren(Node<TYPE>[] children) {
        this.children = children;
    }

    public Node<TYPE> getChild(int index) {
        return this.children[index];
    }

    public Node<TYPE> getNthNode(int n) {
        return this.getNthNode(n, 0);
    }

    private Node<TYPE> getNthNode(int n, int current) {
        if (n == current) {
            return this;
        }
        Node<TYPE> node = null;
        Node<TYPE>[] nodeArray = this.children;
        int n2 = this.children.length;
        int n3 = 0;
        while (n3 < n2) {
            Node<TYPE> child = nodeArray[n3];
            int childLength = child.getLength();
            if (n <= childLength + current && (node = super.getNthNode(n, current + 1)) != null) break;
            current += childLength;
            ++n3;
        }
        return node;
    }

    public void setNthNode(int n, Node<TYPE> newNode) {
        this.setNthNode(n, newNode, 0);
    }

    private void setNthNode(int n, Node<TYPE> newNode, int current) {
        int arity = this.getArity();
        int i = 0;
        while (i < arity) {
            if (current + 1 == n) {
                this.setChild(i, newNode);
                break;
            }
            Node<TYPE> child = this.getChild(i);
            int childLength = child.getLength();
            if (n <= childLength + current) {
                super.setNthNode(n, newNode, current + 1);
            }
            current += childLength;
            ++i;
        }
    }

    public List<Node<TYPE>> getNodesAtDepth(int depth) {
        ArrayList<Node<TYPE>> nodes = new ArrayList<Node<TYPE>>();
        this.fillNodesAtDepth(nodes, depth, 0);
        return nodes;
    }

    private void fillNodesAtDepth(List<Node<TYPE>> nodes, int d, int current) {
        if (d == current) {
            nodes.add(this);
        } else {
            Node<TYPE>[] nodeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                Node<TYPE> child = nodeArray[n2];
                super.fillNodesAtDepth(nodes, d, current + 1);
                ++n2;
            }
        }
    }

    public void setChild(int index, Node<TYPE> child) {
        this.children[index] = child;
    }

    public int getArity() {
        return this.children.length;
    }

    public int getNoTerminals() {
        if (this instanceof TerminalNode) {
            return 1;
        }
        int result = 0;
        int i = 0;
        while (i < this.getArity()) {
            result += this.getChild(i).getNoTerminals();
            ++i;
        }
        return result;
    }

    public int getNoDistinctTerminals() {
        List<TerminalNode<TYPE>> terminals = this.getTerminalNodes();
        HashSet<TerminalNode<TYPE>> terminalHash = new HashSet<TerminalNode<TYPE>>(terminals);
        return terminalHash.size();
    }

    public List<TerminalNode<TYPE>> getTerminalNodes() {
        ArrayList<TerminalNode<TYPE>> terminals = new ArrayList<TerminalNode<TYPE>>();
        if (this instanceof TerminalNode) {
            terminals.add((TerminalNode)this);
        } else {
            int i = 0;
            while (i < this.getArity()) {
                terminals.addAll(this.getChild(i).getTerminalNodes());
                ++i;
            }
        }
        return terminals;
    }

    public int getNoFunctions() {
        if (this instanceof TerminalNode) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < this.getArity()) {
            result += this.getChild(i).getNoFunctions();
            ++i;
        }
        return result;
    }

    public int getNoDistinctFunctions() {
        List<FunctionNode<TYPE>> functions = this.getFunctionNodes();
        ArrayList<String> functionNames = new ArrayList<String>();
        for (FunctionNode<TYPE> f : functions) {
            String name = f.getFunctionName();
            if (functionNames.contains(name)) continue;
            functionNames.add(name);
        }
        return functionNames.size();
    }

    public List<FunctionNode<TYPE>> getFunctionNodes() {
        ArrayList<FunctionNode<TYPE>> functions = new ArrayList<FunctionNode<TYPE>>();
        if (!(this instanceof TerminalNode)) {
            if (this instanceof FunctionNode) {
                functions.add((FunctionNode)this);
            }
            int i = 0;
            while (i < this.getArity()) {
                functions.addAll(this.getChild(i).getFunctionNodes());
                ++i;
            }
        }
        return functions;
    }

    public int getDepth() {
        return this.countDepth(this, 0, 0);
    }

    private int countDepth(Node<TYPE> rootNode, int currentDepth, int depth) {
        int arity;
        if (currentDepth > depth) {
            depth = currentDepth;
        }
        if ((arity = rootNode.getArity()) > 0) {
            int i = 0;
            while (i < arity) {
                Node<TYPE> childNode = rootNode.getChild(i);
                depth = this.countDepth(childNode, currentDepth + 1, depth);
                ++i;
            }
        }
        return depth;
    }

    public int getLength() {
        return this.countLength(this, 0);
    }

    private int countLength(Node<TYPE> rootNode, int length) {
        ++length;
        int arity = rootNode.getArity();
        if (arity > 0) {
            int i = 0;
            while (i < arity) {
                Node<TYPE> childNode = rootNode.getChild(i);
                length = this.countLength(childNode, length);
                ++i;
            }
        }
        return length;
    }

    public int hashCode() {
        int result = 17;
        Node<TYPE>[] nodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Node<TYPE> child = nodeArray[n2];
            result = 37 * result + child.hashCode();
            ++n2;
        }
        return result;
    }

    public Object clone() {
        try {
            Node clone = (Node)super.clone();
            clone.children = (Node[])this.children.clone();
            int i = 0;
            while (i < this.children.length) {
                clone.children[i] = this.children[i];
                if (clone.children[i] != null) {
                    clone.children[i] = (Node)clone.children[i].clone();
                }
                ++i;
            }
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        boolean equal = true;
        if (obj instanceof Node) {
            Node n = (Node)obj;
            if (n.getArity() != this.getArity()) {
                equal = false;
            }
            int i = 0;
            while (i < n.getArity() && equal) {
                Node<TYPE> thatChild = n.getChild(i);
                Node<TYPE> thisChild = this.getChild(i);
                equal = thisChild != null ^ thatChild != null ? false : thisChild == null && thatChild == null || thisChild.equals(thatChild);
                ++i;
            }
        } else {
            equal = false;
        }
        return equal;
    }
}

