/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.representation;

import com.epochx.core.GPModel;
import com.epochx.representation.Node;
import java.util.List;

public class CandidateProgram<TYPE>
implements Cloneable,
Comparable<CandidateProgram<TYPE>> {
    private Node<TYPE> rootNode;
    private GPModel<TYPE> model;

    public CandidateProgram(Node<TYPE> rootNode, GPModel<TYPE> model) {
        this.model = model;
        this.rootNode = rootNode;
    }

    public TYPE evaluate() {
        return this.rootNode.evaluate();
    }

    public Node<TYPE> getRootNode() {
        return this.rootNode;
    }

    public Node<TYPE> getNthNode(int n) {
        int size = this.getProgramLength();
        if (n >= size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + size);
        }
        return this.rootNode.getNthNode(n);
    }

    public void setNthNode(int n, Node<TYPE> newNode) {
        int size;
        if (n == 0) {
            this.rootNode = newNode;
        }
        if (n >= (size = this.getProgramLength())) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + size);
        }
        this.rootNode.setNthNode(n, newNode);
    }

    public List<Node<TYPE>> getNodesAtDepth(int depth) {
        return this.rootNode.getNodesAtDepth(depth);
    }

    public double getFitness() {
        return this.model.getFitness(this);
    }

    public int getNoTerminals() {
        return this.getRootNode().getNoTerminals();
    }

    public int getNoDistinctTerminals() {
        return this.getRootNode().getNoDistinctTerminals();
    }

    public int getNoFunctions() {
        return this.getRootNode().getNoFunctions();
    }

    public int getNoDistinctFunctions() {
        return this.getRootNode().getNoDistinctFunctions();
    }

    public int getProgramDepth() {
        return this.getRootNode().getDepth();
    }

    public int getProgramLength() {
        return this.getRootNode().getLength();
    }

    @Override
    public int compareTo(CandidateProgram<TYPE> o) {
        double objFitness;
        double thisFitness = this.getFitness();
        if (thisFitness > (objFitness = o.getFitness())) {
            return -1;
        }
        if (thisFitness == objFitness) {
            return 0;
        }
        return 1;
    }

    public Object clone() {
        CandidateProgram clone = null;
        try {
            clone = (CandidateProgram)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        clone.rootNode = this.rootNode == null ? null : (Node)this.rootNode.clone();
        clone.model = this.model;
        return clone;
    }

    public String toString() {
        return this.rootNode.toString();
    }

    public boolean equals(Object obj) {
        return this.rootNode.equals(((CandidateProgram)obj).rootNode);
    }
}

