/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.op.mutation;

import com.epochx.core.GPModel;
import com.epochx.op.mutation.Mutation;
import com.epochx.representation.CandidateProgram;
import com.epochx.representation.FunctionNode;
import com.epochx.representation.Node;
import com.epochx.representation.TerminalNode;
import java.util.List;

public class PointMutation<TYPE>
implements Mutation<TYPE> {
    private GPModel<TYPE> model;
    private double pointProbability;

    public PointMutation(GPModel<TYPE> model) {
        this(model, 0.01);
    }

    public PointMutation(GPModel<TYPE> model, double pointProbability) {
        this.model = model;
        this.pointProbability = pointProbability;
    }

    @Override
    public CandidateProgram<TYPE> mutate(CandidateProgram<TYPE> program) {
        List<Node<TYPE>> syntax = this.model.getSyntax();
        int length = program.getProgramLength();
        int i = 0;
        while (i < length) {
            if (this.model.getRNG().nextDouble() < this.pointProbability) {
                Node<TYPE> node = program.getNthNode(i);
                int arity = node.getArity();
                int rand = this.model.getRNG().nextInt(syntax.size());
                int j = 0;
                while (j < syntax.size()) {
                    int index = (j + rand) % syntax.size();
                    Node n = syntax.get(index);
                    if (n.getArity() == arity && !this.nodesEqual(node, n)) {
                        n = (Node)n.clone();
                        int k = 0;
                        while (k < arity) {
                            n.setChild(k, node.getChild(k));
                            ++k;
                        }
                        program.setNthNode(i, n);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return program;
    }

    private boolean nodesEqual(Node<TYPE> nodeA, Node<TYPE> nodeB) {
        boolean equal = false;
        if (nodeA.getClass().equals(nodeB.getClass())) {
            if (nodeA instanceof FunctionNode) {
                equal = true;
            } else if (nodeA instanceof TerminalNode) {
                equal = ((TerminalNode)nodeA).equals(nodeB);
            }
        }
        return equal;
    }
}

