/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.op.crossover;

import com.epochx.core.GPController;
import com.epochx.core.GPModel;
import com.epochx.life.GenerationListener;
import com.epochx.op.crossover.Crossover;
import com.epochx.random.RandomNumberGenerator;
import com.epochx.representation.CandidateProgram;
import com.epochx.representation.FunctionNode;
import com.epochx.representation.Node;
import com.epochx.representation.TerminalNode;

public class KozaCrossover<TYPE>
implements Crossover<TYPE>,
GenerationListener {
    private GPModel<TYPE> model;
    private double functionSwapProbability;
    private RandomNumberGenerator rng;

    public KozaCrossover(GPModel<TYPE> model, double functionSwapProbability) {
        this.model = model;
        this.functionSwapProbability = functionSwapProbability;
        GPController.getLifeCycleManager().addGenerationListener(this);
    }

    public KozaCrossover(GPModel<TYPE> model) {
        this(model, 0.9);
    }

    @Override
    public CandidateProgram<TYPE>[] crossover(CandidateProgram<TYPE> program1, CandidateProgram<TYPE> program2) {
        int swapPoint1 = this.getCrossoverPoint(program1);
        int swapPoint2 = this.getCrossoverPoint(program2);
        Node<TYPE> subtree1 = program1.getNthNode(swapPoint1);
        Node<TYPE> subtree2 = program2.getNthNode(swapPoint2);
        program1.setNthNode(swapPoint1, subtree2);
        program2.setNthNode(swapPoint2, subtree1);
        return new CandidateProgram[]{program1, program2};
    }

    private int getCrossoverPoint(CandidateProgram<TYPE> program) {
        int noTerminals;
        int length = program.getProgramLength();
        int noFunctions = length - (noTerminals = program.getNoTerminals());
        if (noFunctions > 0 && this.rng.nextDouble() < this.functionSwapProbability) {
            int f = this.rng.nextInt(noFunctions);
            int nthFunctionNode = this.getNthFunctionNode(f, program);
            return nthFunctionNode;
        }
        int t = this.rng.nextInt(noTerminals);
        int nthTerminalNode = this.getNthTerminalNode(t, program);
        return nthTerminalNode;
    }

    private int getNthFunctionNode(int n, CandidateProgram<TYPE> program) {
        return this.getNthFunctionNode(n, 0, 0, program.getRootNode());
    }

    private int getNthFunctionNode(int n, int functionCount, int nodeCount, Node<TYPE> current) {
        if (current instanceof FunctionNode && n == functionCount) {
            return nodeCount;
        }
        int result = -1;
        Node<TYPE>[] nodeArray = current.getChildren();
        int n2 = nodeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int childResult;
            Node<TYPE> child = nodeArray[n3];
            int noNodes = child.getLength();
            int noFunctions = child.getNoFunctions();
            if (n <= noFunctions + functionCount && (childResult = this.getNthFunctionNode(n, functionCount + 1, nodeCount + 1, child)) != -1) {
                return childResult;
            }
            functionCount += noFunctions;
            nodeCount += noNodes;
            ++n3;
        }
        return result;
    }

    private int getNthTerminalNode(int n, CandidateProgram<TYPE> program) {
        return this.getNthTerminalNode(n, 0, 0, program.getRootNode());
    }

    private int getNthTerminalNode(int n, int terminalCount, int nodeCount, Node<TYPE> current) {
        if (current instanceof TerminalNode && n == terminalCount++) {
            return nodeCount;
        }
        int result = -1;
        Node<TYPE>[] nodeArray = current.getChildren();
        int n2 = nodeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int childResult;
            Node<TYPE> child = nodeArray[n3];
            int noNodes = child.getLength();
            int noTerminals = child.getNoTerminals();
            if (n <= noTerminals + terminalCount && (childResult = this.getNthTerminalNode(n, terminalCount, nodeCount + 1, child)) != -1) {
                return childResult;
            }
            terminalCount += noTerminals;
            nodeCount += noNodes;
            ++n3;
        }
        return result;
    }

    @Override
    public void onGenerationStart() {
        this.rng = this.model.getRNG();
    }
}

