/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.model.regression;

import com.epochx.core.GPAbstractModel;
import com.epochx.representation.CandidateProgram;
import com.epochx.representation.FunctionNode;
import com.epochx.representation.TerminalNode;
import com.epochx.representation.Variable;
import com.epochx.representation.dbl.AddFunction;
import com.epochx.representation.dbl.MultiplyFunction;
import com.epochx.representation.dbl.ProtectedDivisionFunction;
import com.epochx.representation.dbl.SubtractFunction;
import java.util.ArrayList;
import java.util.List;

public class CubicRegression
extends GPAbstractModel<Double> {
    private Variable<Double> x;

    public CubicRegression() {
        this.configure();
    }

    public void configure() {
        this.x = new Variable("X");
    }

    @Override
    public List<FunctionNode<Double>> getFunctions() {
        ArrayList<FunctionNode<Double>> functions = new ArrayList<FunctionNode<Double>>();
        functions.add(new AddFunction());
        functions.add(new SubtractFunction());
        functions.add(new MultiplyFunction());
        functions.add(new ProtectedDivisionFunction());
        return functions;
    }

    @Override
    public List<TerminalNode<Double>> getTerminals() {
        ArrayList<TerminalNode<Double>> terminals = new ArrayList<TerminalNode<Double>>();
        terminals.add(new TerminalNode<Double>(5.0));
        terminals.add(new TerminalNode<Double>(4.0));
        terminals.add(new TerminalNode<Double>(3.0));
        terminals.add(new TerminalNode<Double>(2.0));
        terminals.add(new TerminalNode<Double>(1.0));
        terminals.add(new TerminalNode<Double>(0.0));
        terminals.add(new TerminalNode<Double>(-5.0));
        terminals.add(new TerminalNode<Double>(-4.0));
        terminals.add(new TerminalNode<Double>(-3.0));
        terminals.add(new TerminalNode<Double>(-2.0));
        terminals.add(new TerminalNode<Double>(-1.0));
        terminals.add(this.x);
        return terminals;
    }

    @Override
    public double getFitness(CandidateProgram<Double> program) {
        double[] inputs = new double[]{-1.0, -0.9, -0.8, -0.7, -0.6, -0.5, -0.4, -0.3, -0.2, -0.1, 0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};
        int noWrong = 0;
        double[] dArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            double in = dArray[n2];
            this.x.setValue(in);
            if (program.evaluate().doubleValue() != this.getCorrectResult(in)) {
                ++noWrong;
            }
            ++n2;
        }
        return noWrong;
    }

    private double getCorrectResult(double x) {
        return x + x * x + x * x * x;
    }
}

