/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.model.multiplexer;

import com.epochx.core.GPAbstractModel;
import com.epochx.representation.CandidateProgram;
import com.epochx.representation.FunctionNode;
import com.epochx.representation.TerminalNode;
import com.epochx.representation.Variable;
import com.epochx.representation.bool.AndFunction;
import com.epochx.representation.bool.IfFunction;
import com.epochx.representation.bool.NotFunction;
import com.epochx.representation.bool.OrFunction;
import com.epochx.util.BoolUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Multiplexer6Bit
extends GPAbstractModel<Boolean> {
    private boolean[][] inputs = BoolUtils.generateBoolSequences(6);
    private HashMap<String, Variable<Boolean>> variables = new HashMap();

    public Multiplexer6Bit() {
        this.configure();
    }

    public void configure() {
        this.variables.put("D3", new Variable("D3"));
        this.variables.put("D2", new Variable("D2"));
        this.variables.put("D1", new Variable("D1"));
        this.variables.put("D0", new Variable("D0"));
        this.variables.put("A1", new Variable("A1"));
        this.variables.put("A0", new Variable("A0"));
    }

    @Override
    public List<FunctionNode<Boolean>> getFunctions() {
        ArrayList<FunctionNode<Boolean>> functions = new ArrayList<FunctionNode<Boolean>>();
        functions.add(new IfFunction());
        functions.add(new AndFunction());
        functions.add(new OrFunction());
        functions.add(new NotFunction());
        return functions;
    }

    @Override
    public List<TerminalNode<Boolean>> getTerminals() {
        ArrayList<TerminalNode<Boolean>> terminals = new ArrayList<TerminalNode<Boolean>>();
        terminals.add((TerminalNode)this.variables.get("D3"));
        terminals.add((TerminalNode)this.variables.get("D2"));
        terminals.add((TerminalNode)this.variables.get("D1"));
        terminals.add((TerminalNode)this.variables.get("D0"));
        terminals.add((TerminalNode)this.variables.get("A1"));
        terminals.add((TerminalNode)this.variables.get("A0"));
        return terminals;
    }

    @Override
    public double getFitness(CandidateProgram<Boolean> program) {
        double score = 0.0;
        boolean[][] blArray = this.inputs;
        int n = this.inputs.length;
        int n2 = 0;
        while (n2 < n) {
            boolean[] in = blArray[n2];
            this.variables.get("A0").setValue(in[0]);
            this.variables.get("A1").setValue(in[1]);
            this.variables.get("D0").setValue(in[2]);
            this.variables.get("D1").setValue(in[3]);
            this.variables.get("D2").setValue(in[4]);
            this.variables.get("D3").setValue(in[5]);
            if (program.evaluate().booleanValue() == this.chooseResult(in)) {
                score += 1.0;
            }
            ++n2;
        }
        return 64.0 - score;
    }

    private boolean chooseResult(boolean[] input) {
        boolean result = false;
        if (input[0] && input[1]) {
            result = input[2];
        } else if (input[0] && !input[1]) {
            result = input[3];
        } else if (!input[0] && input[1]) {
            result = input[4];
        } else if (!input[0] && !input[1]) {
            result = input[5];
        }
        return result;
    }
}

