/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.core;

import com.epochx.core.GPController;
import com.epochx.core.GPGeneration;
import com.epochx.core.GPInitialisation;
import com.epochx.core.GPModel;
import com.epochx.life.LifeCycleManager;
import com.epochx.representation.CandidateProgram;
import com.epochx.stats.GenerationStats;
import java.util.List;

public class GPRun<TYPE> {
    private GPModel<TYPE> model;
    private LifeCycleManager<TYPE> lifeCycle;
    private GPGeneration<TYPE> generation;
    private GPInitialisation<TYPE> initialisation;
    private CandidateProgram<TYPE> bestProgram;
    private double bestFitness;
    private long runStartTime;
    private long runEndTime;
    private GenerationStats<TYPE> genStats;

    private GPRun(GPModel<TYPE> model) {
        this.model = model;
        this.lifeCycle = GPController.getLifeCycleManager();
        this.runStartTime = System.nanoTime();
        this.runEndTime = -1L;
        this.bestProgram = null;
        this.bestFitness = Double.POSITIVE_INFINITY;
        this.generation = new GPGeneration<TYPE>(model);
        this.initialisation = new GPInitialisation<TYPE>(model);
        this.genStats = new GenerationStats();
        this.genStats.addGenerationStatListener(model.getGenerationStatListener());
    }

    public static <TYPE> GPRun<TYPE> run(GPModel<TYPE> model) {
        GPRun<TYPE> runner = new GPRun<TYPE>(model);
        super.run();
        return runner;
    }

    private void run() {
        this.genStats.setStartTime();
        this.lifeCycle.onRunStart();
        List<CandidateProgram<TYPE>> pop = this.initialisation.initialise();
        this.genStats.addGen(pop, 0);
        this.updateBestProgram(pop);
        boolean fitnessSuccess = false;
        int gen = 1;
        while (gen <= this.model.getNoGenerations()) {
            pop = this.generation.generation(pop);
            this.genStats.addGen(pop, gen);
            this.updateBestProgram(pop);
            if (this.bestFitness <= this.model.getTerminationFitness()) {
                fitnessSuccess = true;
                break;
            }
            ++gen;
        }
        if (fitnessSuccess) {
            this.model.getLifeCycleListener().onFitnessTermination();
        } else {
            this.model.getLifeCycleListener().onGenerationTermination();
        }
        this.runEndTime = System.nanoTime();
    }

    private void updateBestProgram(List<CandidateProgram<TYPE>> pop) {
        for (CandidateProgram<TYPE> program : pop) {
            double fitness = program.getFitness();
            if (!(fitness < this.bestFitness)) continue;
            this.bestFitness = fitness;
            this.bestProgram = program;
        }
    }

    public CandidateProgram<TYPE> getBestProgram() {
        return this.bestProgram;
    }

    public double getBestFitness() {
        return this.bestFitness;
    }

    public long getRunTime() {
        if (this.runEndTime == -1L) {
            return System.nanoTime() - this.runStartTime;
        }
        return this.runEndTime - this.runStartTime;
    }
}

