/*
 * Decompiled with CFR 0.152.
 */
package com.epochx.core;

import com.epochx.core.GPController;
import com.epochx.core.GPModel;
import com.epochx.life.GenerationListener;
import com.epochx.life.LifeCycleManager;
import com.epochx.op.selection.PoolSelector;
import com.epochx.representation.CandidateProgram;
import java.util.List;

public class GPPoolSelection<TYPE>
implements GenerationListener {
    private GPModel<TYPE> model;
    private LifeCycleManager<TYPE> lifeCycle;
    private PoolSelector<TYPE> poolSelector;
    private int poolSize;
    private int reversions;

    public GPPoolSelection(GPModel<TYPE> model) {
        this.model = model;
        this.lifeCycle = GPController.getLifeCycleManager();
        this.lifeCycle.addGenerationListener(this);
        this.initialise();
    }

    private void initialise() {
        this.poolSize = this.model.getPoolSize();
        this.poolSelector = this.model.getPoolSelector();
    }

    public List<CandidateProgram<TYPE>> getPool(List<CandidateProgram<TYPE>> pop) {
        List<CandidateProgram<TYPE>> pool = null;
        this.reversions = -1;
        do {
            pool = this.poolSelector.getPool(pop, this.poolSize);
            pool = this.lifeCycle.onPoolSelection(pool);
            ++this.reversions;
        } while (pool == null);
        return pool;
    }

    public int getReversions() {
        return this.reversions;
    }

    @Override
    public void onGenerationStart() {
        this.initialise();
    }
}

